/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.concurrent;

import java.util.concurrent.TimeoutException;
import org.linkedin.util.annotations.Initializable;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.ClockUtils;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.concurrent.ConcurrentUtils;

public class WaitableCounter {
    @Initializable
    public Clock clock = SystemClock.INSTANCE;
    private int _counter;

    public WaitableCounter(int counter) {
        this._counter = counter;
    }

    public WaitableCounter() {
        this(0);
    }

    public synchronized void dec() {
        --this._counter;
        if (this._counter == 0) {
            this.notifyAll();
        }
    }

    public synchronized void inc() {
        ++this._counter;
    }

    public synchronized int getCounter() {
        return this._counter;
    }

    public synchronized void waitForCounter() throws InterruptedException {
        while (this._counter > 0) {
            this.wait();
        }
    }

    public synchronized void waitForCounter(Object timeout) throws InterruptedException, TimeoutException {
        long endTime = ClockUtils.toEndTime(this.clock, timeout);
        while (this._counter > 0) {
            ConcurrentUtils.awaitUntil(this.clock, this, endTime);
        }
    }
}

