/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.snappy;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.iq80.snappy.BufferRecycler;
import org.iq80.snappy.CorruptionException;
import org.iq80.snappy.Crc32C;
import org.iq80.snappy.Snappy;
import org.iq80.snappy.SnappyInternalUtils;
import org.iq80.snappy.SnappyOutputStream;

public class SnappyInputStream
extends InputStream {
    private final BufferRecycler recycler;
    private final byte[] input;
    private final byte[] uncompressed;
    private final byte[] header = new byte[7];
    private final InputStream in;
    private final boolean verifyChecksums;
    private byte[] buffer;
    private int valid;
    private int position;
    private boolean closed;
    private boolean eof;

    public SnappyInputStream(InputStream in) throws IOException {
        this(in, true);
    }

    public SnappyInputStream(InputStream in, boolean verifyChecksums) throws IOException {
        int size2;
        this.in = in;
        this.verifyChecksums = verifyChecksums;
        this.recycler = BufferRecycler.instance();
        this.input = this.recycler.allocInputBuffer(32768);
        this.uncompressed = this.recycler.allocDecodeBuffer(32768);
        for (int offset = 0; offset < this.header.length; offset += size2) {
            size2 = in.read(this.header, offset, this.header.length - offset);
            if (size2 != -1) continue;
            throw new EOFException("encountered EOF while reading stream header");
        }
        if (!Arrays.equals(this.header, SnappyOutputStream.STREAM_HEADER)) {
            throw new IOException("invalid stream header");
        }
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (!this.ensureBuffer()) {
            return -1;
        }
        return this.buffer[this.position++];
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        SnappyInternalUtils.checkNotNull(output, "output is null", new Object[0]);
        SnappyInternalUtils.checkPositionIndexes(offset, offset + length, output.length);
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (length == 0) {
            return 0;
        }
        if (!this.ensureBuffer()) {
            return -1;
        }
        int size2 = Math.min(length, this.available());
        System.arraycopy(this.buffer, this.position, output, offset, size2);
        this.position += size2;
        return size2;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        return this.valid - this.position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (!this.closed) {
                this.closed = true;
                this.recycler.releaseInputBuffer(this.input);
                this.recycler.releaseDecodeBuffer(this.uncompressed);
            }
        }
    }

    private boolean ensureBuffer() throws IOException {
        if (this.available() > 0) {
            return true;
        }
        if (this.eof) {
            return false;
        }
        if (!this.readBlockHeader()) {
            this.eof = true;
            return false;
        }
        boolean compressed = this.getHeaderCompressedFlag();
        int length = this.getHeaderLength();
        this.readInput(length);
        this.handleInput(length, compressed);
        return true;
    }

    private void handleInput(int length, boolean compressed) throws IOException {
        int actualCrc32c;
        int expectedCrc32c;
        if (compressed) {
            this.buffer = this.uncompressed;
            try {
                this.valid = Snappy.uncompress(this.input, 0, length, this.uncompressed, 0);
            }
            catch (CorruptionException e) {
                throw new IOException("Corrupt input", e);
            }
        } else {
            this.buffer = this.input;
            this.valid = length;
        }
        if (this.verifyChecksums && (expectedCrc32c = this.getCrc32c()) != (actualCrc32c = Crc32C.maskedCrc32c(this.buffer, 0, this.valid))) {
            throw new IOException("Corrupt input: invalid checksum");
        }
        this.position = 0;
    }

    private void readInput(int length) throws IOException {
        int size2;
        for (int offset = 0; offset < length; offset += size2) {
            size2 = this.in.read(this.input, offset, length - offset);
            if (size2 != -1) continue;
            throw new EOFException("encountered EOF while reading block data");
        }
    }

    private boolean readBlockHeader() throws IOException {
        do {
            int size2;
            for (int offset = 0; offset < this.header.length; offset += size2) {
                size2 = this.in.read(this.header, offset, this.header.length - offset);
                if (size2 != -1) continue;
                if (offset == 0) {
                    return false;
                }
                throw new EOFException("encountered EOF while reading block header");
            }
        } while (Arrays.equals(this.header, SnappyOutputStream.STREAM_HEADER));
        return true;
    }

    private boolean getHeaderCompressedFlag() throws IOException {
        int x = this.header[0] & 0xFF;
        switch (x) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException(String.format("invalid compressed flag in header: 0x%02x", x));
    }

    private int getHeaderLength() throws IOException {
        int a = this.header[1] & 0xFF;
        int b = this.header[2] & 0xFF;
        int length = a << 8 | b;
        if (length <= 0 || length > 32768) {
            throw new IOException("invalid block size in header: " + length);
        }
        return length;
    }

    private int getCrc32c() throws IOException {
        return (this.header[3] & 0xFF) << 24 | (this.header[4] & 0xFF) << 16 | (this.header[5] & 0xFF) << 8 | this.header[6] & 0xFF;
    }
}

