/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtbuf.proto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.BufferOutputStream;
import org.fusesource.hawtbuf.proto.CodedInputStream;
import org.fusesource.hawtbuf.proto.CodedOutputStream;
import org.fusesource.hawtbuf.proto.InvalidProtocolBufferException;
import org.fusesource.hawtbuf.proto.Message;
import org.fusesource.hawtbuf.proto.UninitializedMessageException;
import org.fusesource.hawtbuf.proto.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMessage<T>
implements Message<T> {
    protected int memoizedSerializedSize = -1;

    @Override
    public abstract T clone() throws CloneNotSupportedException;

    @Override
    public void clear() {
        this.memoizedSerializedSize = -1;
    }

    public boolean isInitialized() {
        return this.missingFields().isEmpty();
    }

    @Override
    public T assertInitialized() throws UninitializedMessageException {
        ArrayList<String> missingFields = this.missingFields();
        if (!missingFields.isEmpty()) {
            throw new UninitializedMessageException(missingFields);
        }
        return this.getThis();
    }

    protected T checktInitialized() throws InvalidProtocolBufferException {
        ArrayList<String> missingFields = this.missingFields();
        if (!missingFields.isEmpty()) {
            throw new UninitializedMessageException(missingFields).asInvalidProtocolBufferException();
        }
        return this.getThis();
    }

    public ArrayList<String> missingFields() {
        this.load();
        return new ArrayList<String>();
    }

    protected void loadAndClear() {
        this.memoizedSerializedSize = -1;
    }

    protected void load() {
    }

    @Override
    public T mergeFrom(T other) {
        return this.getThis();
    }

    @Override
    public void writeUnframed(CodedOutputStream output) throws IOException {
    }

    @Override
    public void writeFramed(CodedOutputStream output) throws IOException {
        output.writeRawVarint32(this.serializedSizeUnframed());
        this.writeUnframed(output);
    }

    @Override
    public Buffer toUnframedBuffer() {
        try {
            int size2 = this.serializedSizeUnframed();
            BufferOutputStream baos = new BufferOutputStream(size2);
            CodedOutputStream output = new CodedOutputStream(baos);
            this.writeUnframed(output);
            Buffer rc = baos.toBuffer();
            if (rc.length != size2) {
                throw new IllegalStateException("Did not write as much data as expected.");
            }
            return rc;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    @Override
    public Buffer toFramedBuffer() {
        try {
            int size2 = this.serializedSizeFramed();
            BufferOutputStream baos = new BufferOutputStream(size2);
            CodedOutputStream output = new CodedOutputStream(baos);
            this.writeFramed(output);
            Buffer rc = baos.toBuffer();
            if (rc.length != size2) {
                throw new IllegalStateException("Did not write as much data as expected.");
            }
            return rc;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    @Override
    public byte[] toUnframedByteArray() {
        return this.toUnframedBuffer().toByteArray();
    }

    @Override
    public byte[] toFramedByteArray() {
        return this.toFramedBuffer().toByteArray();
    }

    @Override
    public void writeFramed(OutputStream output) throws IOException {
        CodedOutputStream codedOutput = new CodedOutputStream(output);
        this.writeFramed(codedOutput);
        codedOutput.flush();
    }

    @Override
    public void writeUnframed(OutputStream output) throws IOException {
        CodedOutputStream codedOutput = new CodedOutputStream(output);
        this.writeUnframed(codedOutput);
        codedOutput.flush();
    }

    @Override
    public int serializedSizeFramed() {
        int t = this.serializedSizeUnframed();
        return CodedOutputStream.computeRawVarint32Size(t) + t;
    }

    @Override
    public T mergeFramed(CodedInputStream input) throws IOException {
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        Object rc = this.mergeUnframed(input);
        input.checkLastTagWas(0);
        input.popLimit(oldLimit);
        return rc;
    }

    @Override
    public T mergeUnframed(Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            this.mergeUnframed(input);
            input.checkLastTagWas(0);
            return this.getThis();
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    private T getThis() {
        return (T)this;
    }

    @Override
    public T mergeFramed(Buffer data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = new CodedInputStream(data);
            this.mergeFramed(input);
            input.checkLastTagWas(0);
            return this.getThis();
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("An IOException was thrown (should never happen in this method).", e);
        }
    }

    @Override
    public T mergeUnframed(byte[] data) throws InvalidProtocolBufferException {
        return this.mergeUnframed(new Buffer(data));
    }

    @Override
    public T mergeFramed(byte[] data) throws InvalidProtocolBufferException {
        return this.mergeFramed(new Buffer(data));
    }

    @Override
    public T mergeUnframed(InputStream input) throws IOException {
        CodedInputStream codedInput = new CodedInputStream(input);
        this.mergeUnframed(codedInput);
        return this.getThis();
    }

    @Override
    public T mergeFramed(InputStream input) throws IOException {
        int r;
        int length = BaseMessage.readRawVarint32(input);
        byte[] data = new byte[length];
        for (int pos = 0; pos < length; pos += r) {
            r = input.read(data, pos, length - pos);
            if (r >= 0) continue;
            throw new InvalidProtocolBufferException("Input stream ended before a full message frame could be read.");
        }
        return this.mergeUnframed(data);
    }

    protected static <T> void addAll(Iterable<T> values, Collection<? super T> list) {
        if (values instanceof Collection) {
            Collection collection = (Collection)values;
            list.addAll(collection);
        } else {
            for (T value : values) {
                list.add(value);
            }
        }
    }

    protected static void writeGroup(CodedOutputStream output, int tag, BaseMessage message) throws IOException {
        output.writeTag(tag, 3);
        message.writeUnframed(output);
        output.writeTag(tag, 4);
    }

    protected static <T extends BaseMessage> T readGroup(CodedInputStream input, int tag, T group) throws IOException {
        group.mergeUnframed(input);
        input.checkLastTagWas(WireFormat.makeTag(tag, 4));
        return group;
    }

    protected static int computeGroupSize(int tag, BaseMessage message) {
        return CodedOutputStream.computeTagSize(tag) * 2 + message.serializedSizeUnframed();
    }

    protected static void writeMessage(CodedOutputStream output, int tag, BaseMessage message) throws IOException {
        output.writeTag(tag, 2);
        message.writeFramed(output);
    }

    protected static int computeMessageSize(int tag, BaseMessage message) {
        return CodedOutputStream.computeTagSize(tag) + message.serializedSizeFramed();
    }

    protected List<String> prefix(List<String> missingFields, String prefix) {
        ArrayList<String> rc = new ArrayList<String>(missingFields.size());
        for (String v : missingFields) {
            rc.add(prefix + v);
        }
        return rc;
    }

    public static int readRawVarint32(InputStream is) throws IOException {
        byte tmp = BaseMessage.readRawByte(is);
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = BaseMessage.readRawByte(is);
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = BaseMessage.readRawByte(is);
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = BaseMessage.readRawByte(is);
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = BaseMessage.readRawByte(is);
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (BaseMessage.readRawByte(is) < 0) continue;
                            return result;
                        }
                        throw new InvalidProtocolBufferException("CodedInputStream encountered a malformed varint.");
                    }
                }
            }
        }
        return result;
    }

    protected static byte readRawByte(InputStream is) throws IOException {
        int rc = is.read();
        if (rc == -1) {
            throw new InvalidProtocolBufferException("While parsing a protocol message, the input ended unexpectedly in the middle of a field.  This could mean either than the input has been truncated or that an embedded message misreported its own length.");
        }
        return (byte)rc;
    }
}

