/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.linkedin.util.io.resource.FileResource;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.URIResourceFactory;
import org.linkedin.util.io.resource.UnsupportedURIException;
import org.linkedin.util.io.resource.internal.SchemeURIResourceFactory;

public class URIResourceFactoryImpl
implements URIResourceFactory {
    private final Map<String, SchemeURIResourceFactory> _factories = new HashMap<String, SchemeURIResourceFactory>();

    public URIResourceFactoryImpl(SchemeURIResourceFactory ... factories) {
        for (SchemeURIResourceFactory factory : factories) {
            this._factories.put(factory.getScheme(), factory);
        }
    }

    @Override
    public Resource createResource(URI uri) throws UnsupportedURIException {
        if (uri.getScheme() == null) {
            return FileResource.createFromRoot(new File(uri.getPath()));
        }
        SchemeURIResourceFactory factory = this._factories.get(uri.getScheme());
        if (factory == null) {
            throw new UnsupportedURIException("unsupported scheme " + uri.getScheme());
        }
        return factory.createResource(uri, this);
    }
}

