/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component.broker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.broker.view.MessageBrokerView;
import org.apache.activemq.broker.view.MessageBrokerViewRegistry;
import org.apache.activemq.camel.component.broker.BrokerConfiguration;
import org.apache.activemq.camel.component.broker.BrokerEndpoint;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.EndpointCompleter;
import org.apache.camel.util.ObjectHelper;

public class BrokerComponent
extends UriEndpointComponent
implements EndpointCompleter {
    public BrokerComponent() {
        super(BrokerEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BrokerConfiguration brokerConfiguration = new BrokerConfiguration();
        this.setProperties(brokerConfiguration, parameters);
        int destinationType = 1;
        if (remaining.startsWith("queue:")) {
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("queue:".length()), (char)'/');
        } else if (remaining.startsWith("topic:")) {
            destinationType = 2;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("topic:".length()), (char)'/');
        } else if (remaining.startsWith("temp-queue:")) {
            destinationType = 5;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp-queue:".length()), (char)'/');
        } else if (remaining.startsWith("temp-topic:")) {
            destinationType = 6;
            remaining = ObjectHelper.removeStartingCharacters((String)remaining.substring("temp-topic:".length()), (char)'/');
        }
        ActiveMQDestination destination = ActiveMQDestination.createDestination(remaining, (byte)destinationType);
        BrokerEndpoint brokerEndpoint = new BrokerEndpoint(uri, this, remaining, destination, brokerConfiguration);
        this.setProperties((Object)brokerEndpoint, parameters);
        return brokerEndpoint;
    }

    public List<String> completeEndpointPath(ComponentConfiguration componentConfiguration, String completionText) {
        String brokerName = String.valueOf(componentConfiguration.getParameter("brokerName"));
        MessageBrokerView messageBrokerView = MessageBrokerViewRegistry.getInstance().lookup(brokerName);
        if (messageBrokerView != null) {
            String destinationName = completionText;
            Set<ActiveMQDestination> set2 = messageBrokerView.getQueues();
            if (completionText.startsWith("topic:")) {
                set2 = messageBrokerView.getTopics();
                destinationName = completionText.substring(6);
            } else if (completionText.startsWith("queue:")) {
                destinationName = completionText.substring(6);
            }
            ArrayList<String> answer = new ArrayList<String>();
            for (ActiveMQDestination destination : set2) {
                if (!destination.getPhysicalName().startsWith(destinationName)) continue;
                answer.add(destination.getPhysicalName());
            }
            return answer;
        }
        return null;
    }
}

