/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.EmptyBroker;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.BaseDestination;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFactory;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueRegion;
import org.apache.activemq.broker.region.Region;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TempQueueRegion;
import org.apache.activemq.broker.region.TempTopicRegion;
import org.apache.activemq.broker.region.TopicRegion;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.store.PListStore;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.util.BrokerSupport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.InetAddressUtil;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionBroker
extends EmptyBroker {
    public static final String ORIGINAL_EXPIRATION = "originalExpiration";
    private static final Logger LOG = LoggerFactory.getLogger(RegionBroker.class);
    private static final IdGenerator BROKER_ID_GENERATOR = new IdGenerator();
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    protected DestinationFactory destinationFactory;
    protected final Map<ConnectionId, ConnectionState> connectionStates = Collections.synchronizedMap(new HashMap());
    private final Region queueRegion;
    private final Region topicRegion;
    private final Region tempQueueRegion;
    private final Region tempTopicRegion;
    protected final BrokerService brokerService;
    private boolean started;
    private boolean keepDurableSubsActive;
    private final CopyOnWriteArrayList<Connection> connections = new CopyOnWriteArrayList();
    private final Map<ActiveMQDestination, Destination> destinations = new ConcurrentHashMap<ActiveMQDestination, Destination>();
    private final Map<BrokerId, BrokerInfo> brokerInfos = new HashMap<BrokerId, BrokerInfo>();
    private final LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    private BrokerId brokerId;
    private String brokerName;
    private final Map<String, ConnectionContext> clientIdSet = new HashMap<String, ConnectionContext>();
    private final DestinationInterceptor destinationInterceptor;
    private ConnectionContext adminConnectionContext;
    private final Scheduler scheduler;
    private final ThreadPoolExecutor executor;
    private boolean allowTempAutoCreationOnSend;
    private final ReentrantReadWriteLock inactiveDestinationsPurgeLock = new ReentrantReadWriteLock();
    private final Runnable purgeInactiveDestinationsTask = new Runnable(){

        @Override
        public void run() {
            RegionBroker.this.purgeInactiveDestinations();
        }
    };

    public RegionBroker(BrokerService brokerService, TaskRunnerFactory taskRunnerFactory, SystemUsage memoryManager, DestinationFactory destinationFactory, DestinationInterceptor destinationInterceptor, Scheduler scheduler, ThreadPoolExecutor executor) throws IOException {
        this.brokerService = brokerService;
        this.executor = executor;
        this.scheduler = scheduler;
        if (destinationFactory == null) {
            throw new IllegalArgumentException("null destinationFactory");
        }
        this.sequenceGenerator.setLastSequenceId(destinationFactory.getLastMessageBrokerSequenceId());
        this.destinationFactory = destinationFactory;
        this.queueRegion = this.createQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.topicRegion = this.createTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.destinationInterceptor = destinationInterceptor;
        this.tempQueueRegion = this.createTempQueueRegion(memoryManager, taskRunnerFactory, destinationFactory);
        this.tempTopicRegion = this.createTempTopicRegion(memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public Map<ActiveMQDestination, Destination> getDestinationMap() {
        HashMap<ActiveMQDestination, Destination> answer = new HashMap<ActiveMQDestination, Destination>(this.getQueueRegion().getDestinationMap());
        answer.putAll(this.getTopicRegion().getDestinationMap());
        return answer;
    }

    @Override
    public Set<Destination> getDestinations(ActiveMQDestination destination) {
        try {
            return this.getRegion(destination).getDestinations(destination);
        }
        catch (JMSException jmse) {
            return Collections.emptySet();
        }
    }

    @Override
    public Broker getAdaptor(Class type) {
        if (type.isInstance(this)) {
            return this;
        }
        return null;
    }

    public Region getQueueRegion() {
        return this.queueRegion;
    }

    public Region getTempQueueRegion() {
        return this.tempQueueRegion;
    }

    public Region getTempTopicRegion() {
        return this.tempTopicRegion;
    }

    public Region getTopicRegion() {
        return this.topicRegion;
    }

    protected Region createTempTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTempQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TempQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createTopicRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new TopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    protected Region createQueueRegion(SystemUsage memoryManager, TaskRunnerFactory taskRunnerFactory, DestinationFactory destinationFactory) {
        return new QueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, destinationFactory);
    }

    @Override
    public void start() throws Exception {
        this.started = true;
        this.queueRegion.start();
        this.topicRegion.start();
        this.tempQueueRegion.start();
        this.tempTopicRegion.start();
        int period = this.brokerService.getSchedulePeriodForDestinationPurge();
        if (period > 0) {
            this.scheduler.executePeriodically(this.purgeInactiveDestinationsTask, period);
        }
    }

    @Override
    public void stop() throws Exception {
        this.started = false;
        this.scheduler.cancel(this.purgeInactiveDestinationsTask);
        ServiceStopper ss = new ServiceStopper();
        this.doStop(ss);
        ss.throwFirstException();
        this.clientIdSet.clear();
        this.connections.clear();
        this.destinations.clear();
        this.brokerInfos.clear();
    }

    public PolicyMap getDestinationPolicy() {
        return this.brokerService != null ? this.brokerService.getDestinationPolicy() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info2) throws Exception {
        String clientId = info2.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection request");
        }
        Map<String, ConnectionContext> map2 = this.clientIdSet;
        synchronized (map2) {
            ConnectionContext oldContext = this.clientIdSet.get(clientId);
            if (oldContext != null) {
                throw new InvalidClientIDException("Broker: " + this.getBrokerName() + " - Client: " + clientId + " already connected from " + oldContext.getConnection().getRemoteAddress());
            }
            this.clientIdSet.put(clientId, context);
        }
        this.connections.add(context.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info2, Throwable error2) throws Exception {
        String clientId = info2.getClientId();
        if (clientId == null) {
            throw new InvalidClientIDException("No clientID specified for connection disconnect request");
        }
        Map<String, ConnectionContext> map2 = this.clientIdSet;
        synchronized (map2) {
            ConnectionContext oldValue = this.clientIdSet.get(clientId);
            if (oldValue == context && this.isEqual(oldValue.getConnectionId(), info2.getConnectionId())) {
                this.clientIdSet.remove(clientId);
            }
        }
        this.connections.remove(context.getConnection());
    }

    protected boolean isEqual(ConnectionId connectionId, ConnectionId connectionId2) {
        return connectionId == connectionId2 || connectionId != null && connectionId.equals(connectionId2);
    }

    @Override
    public Connection[] getClients() throws Exception {
        ArrayList<Connection> l = new ArrayList<Connection>(this.connections);
        Connection[] rc = new Connection[l.size()];
        l.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemp) throws Exception {
        Destination answer = this.destinations.get(destination);
        if (answer != null) {
            return answer;
        }
        Map<ActiveMQDestination, Destination> map2 = this.destinations;
        synchronized (map2) {
            answer = this.destinations.get(destination);
            if (answer != null) {
                return answer;
            }
            boolean create = true;
            if (destination.isTemporary()) {
                create = createIfTemp;
            }
            answer = this.getRegion(destination).addDestination(context, destination, create);
            this.destinations.put(destination, answer);
            return answer;
        }
    }

    @Override
    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Exception {
        if (this.destinations.containsKey(destination)) {
            this.getRegion(destination).removeDestination(context, destination, timeout);
            this.destinations.remove(destination);
        }
    }

    @Override
    public void addDestinationInfo(ConnectionContext context, DestinationInfo info2) throws Exception {
        this.addDestination(context, info2.getDestination(), true);
    }

    @Override
    public void removeDestinationInfo(ConnectionContext context, DestinationInfo info2) throws Exception {
        this.removeDestination(context, info2.getDestination(), info2.getTimeout());
    }

    @Override
    public ActiveMQDestination[] getDestinations() throws Exception {
        ArrayList<ActiveMQDestination> l = new ArrayList<ActiveMQDestination>(this.getDestinationMap().keySet());
        ActiveMQDestination[] rc = new ActiveMQDestination[l.size()];
        l.toArray(rc);
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ConnectionContext context, ProducerInfo info2) throws Exception {
        ActiveMQDestination destination = info2.getDestination();
        if (destination != null) {
            this.inactiveDestinationsPurgeLock.readLock().lock();
            try {
                context.getBroker().addDestination(context, destination, this.isAllowTempAutoCreationOnSend());
                this.getRegion(destination).addProducer(context, info2);
            }
            finally {
                this.inactiveDestinationsPurgeLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ConnectionContext context, ProducerInfo info2) throws Exception {
        ActiveMQDestination destination = info2.getDestination();
        if (destination != null) {
            this.inactiveDestinationsPurgeLock.readLock().lock();
            try {
                this.getRegion(destination).removeProducer(context, info2);
            }
            finally {
                this.inactiveDestinationsPurgeLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription addConsumer(ConnectionContext context, ConsumerInfo info2) throws Exception {
        ActiveMQDestination destination = info2.getDestination();
        if (this.destinationInterceptor != null) {
            this.destinationInterceptor.create(this, context, destination);
        }
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            Subscription subscription = this.getRegion(destination).addConsumer(context, info2);
            return subscription;
        }
        finally {
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ConnectionContext context, ConsumerInfo info2) throws Exception {
        ActiveMQDestination destination = info2.getDestination();
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            this.getRegion(destination).removeConsumer(context, info2);
        }
        finally {
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info2) throws Exception {
        this.inactiveDestinationsPurgeLock.readLock().lock();
        try {
            this.topicRegion.removeSubscription(context, info2);
        }
        finally {
            this.inactiveDestinationsPurgeLock.readLock().unlock();
        }
    }

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        ActiveMQDestination destination = message.getDestination();
        message.setBrokerInTime(System.currentTimeMillis());
        if (producerExchange.isMutable() || producerExchange.getRegion() == null || producerExchange.getRegionDestination() != null && producerExchange.getRegionDestination().isDisposed()) {
            producerExchange.getConnectionContext().getBroker().addDestination(producerExchange.getConnectionContext(), destination, this.isAllowTempAutoCreationOnSend());
            producerExchange.setRegion(this.getRegion(destination));
            producerExchange.setRegionDestination(null);
        }
        producerExchange.getRegion().send(producerExchange, message);
        if (producerExchange.isMutable()) {
            producerExchange.setRegionDestination(null);
            producerExchange.setRegion(null);
        }
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        if (consumerExchange.isWildcard() || consumerExchange.getRegion() == null) {
            ActiveMQDestination destination = ack.getDestination();
            consumerExchange.setRegion(this.getRegion(destination));
        }
        consumerExchange.getRegion().acknowledge(consumerExchange, ack);
    }

    protected Region getRegion(ActiveMQDestination destination) throws JMSException {
        switch (destination.getDestinationType()) {
            case 1: {
                return this.queueRegion;
            }
            case 2: {
                return this.topicRegion;
            }
            case 5: {
                return this.tempQueueRegion;
            }
            case 6: {
                return this.tempTopicRegion;
            }
        }
        throw this.createUnknownDestinationTypeException(destination);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        ActiveMQDestination destination = pull.getDestination();
        return this.getRegion(destination).messagePull(context, pull);
    }

    @Override
    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    @Override
    public void gc() {
        this.queueRegion.gc();
        this.topicRegion.gc();
    }

    @Override
    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(BROKER_ID_GENERATOR.generateId());
        }
        return this.brokerId;
    }

    public void setBrokerId(BrokerId brokerId) {
        this.brokerId = brokerId;
    }

    @Override
    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddressUtil.getLocalHostName().toLowerCase(Locale.ENGLISH);
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    protected JMSException createUnknownDestinationTypeException(ActiveMQDestination destination) {
        return new JMSException("Unknown destination type: " + destination.getDestinationType());
    }

    @Override
    public synchronized void addBroker(Connection connection, BrokerInfo info2) {
        BrokerInfo existing = this.brokerInfos.get(info2.getBrokerId());
        if (existing == null) {
            existing = info2.copy();
            existing.setPeerBrokerInfos(null);
            this.brokerInfos.put(info2.getBrokerId(), existing);
        }
        existing.incrementRefCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getBrokerName() + " addBroker:" + info2.getBrokerName() + " brokerInfo size : " + this.brokerInfos.size());
        }
        this.addBrokerInClusterUpdate(info2);
    }

    @Override
    public synchronized void removeBroker(Connection connection, BrokerInfo info2) {
        if (info2 != null) {
            BrokerInfo existing = this.brokerInfos.get(info2.getBrokerId());
            if (existing != null && existing.decrementRefCount() == 0) {
                this.brokerInfos.remove(info2.getBrokerId());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getBrokerName() + " removeBroker:" + info2.getBrokerName() + " brokerInfo size : " + this.brokerInfos.size());
            }
            this.removeBrokerInClusterUpdate(info2);
        }
    }

    @Override
    public synchronized BrokerInfo[] getPeerBrokerInfos() {
        BrokerInfo[] result = new BrokerInfo[this.brokerInfos.size()];
        result = this.brokerInfos.values().toArray(result);
        return result;
    }

    @Override
    public void preProcessDispatch(MessageDispatch messageDispatch) {
        Message message = messageDispatch.getMessage();
        if (message != null) {
            long endTime = System.currentTimeMillis();
            message.setBrokerOutTime(endTime);
            if (this.getBrokerService().isEnableStatistics()) {
                long totalTime = endTime - message.getBrokerInTime();
                ((Destination)message.getRegionDestination()).getDestinationStatistics().getProcessTime().addTime(totalTime);
            }
        }
    }

    @Override
    public void postProcessDispatch(MessageDispatch messageDispatch) {
    }

    @Override
    public void processDispatchNotification(MessageDispatchNotification messageDispatchNotification) throws Exception {
        ActiveMQDestination destination = messageDispatchNotification.getDestination();
        this.getRegion(destination).processDispatchNotification(messageDispatchNotification);
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public Set<ActiveMQDestination> getDurableDestinations() {
        return this.destinationFactory.getDestinations();
    }

    protected void doStop(ServiceStopper ss) {
        ss.stop(this.queueRegion);
        ss.stop(this.topicRegion);
        ss.stop(this.tempQueueRegion);
        ss.stop(this.tempTopicRegion);
    }

    public boolean isKeepDurableSubsActive() {
        return this.keepDurableSubsActive;
    }

    public void setKeepDurableSubsActive(boolean keepDurableSubsActive) {
        this.keepDurableSubsActive = keepDurableSubsActive;
        ((TopicRegion)this.topicRegion).setKeepDurableSubsActive(keepDurableSubsActive);
    }

    public DestinationInterceptor getDestinationInterceptor() {
        return this.destinationInterceptor;
    }

    @Override
    public ConnectionContext getAdminConnectionContext() {
        return this.adminConnectionContext;
    }

    @Override
    public void setAdminConnectionContext(ConnectionContext adminConnectionContext) {
        this.adminConnectionContext = adminConnectionContext;
    }

    public Map<ConnectionId, ConnectionState> getConnectionStates() {
        return this.connectionStates;
    }

    @Override
    public PListStore getTempDataStore() {
        return this.brokerService.getTempDataStore();
    }

    @Override
    public URI getVmConnectorURI() {
        return this.brokerService.getVmConnectorURI();
    }

    @Override
    public void brokerServiceStarted() {
    }

    @Override
    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExpired(MessageReference messageReference) {
        boolean expired = false;
        if (messageReference.isExpired()) {
            try {
                Message message;
                Message message2 = message = messageReference.getMessage();
                synchronized (message2) {
                    expired = this.stampAsExpired(message);
                }
            }
            catch (IOException e) {
                LOG.warn("unexpected exception on message expiry determination for: " + messageReference, (Throwable)e);
            }
        }
        return expired;
    }

    private boolean stampAsExpired(Message message) throws IOException {
        boolean stamped = false;
        if (message.getProperty(ORIGINAL_EXPIRATION) == null) {
            long expiration = message.getExpiration();
            message.setProperty(ORIGINAL_EXPIRATION, new Long(expiration));
            stamped = true;
        }
        return stamped;
    }

    @Override
    public void messageExpired(ConnectionContext context, MessageReference node, Subscription subscription) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message expired " + node);
        }
        this.getRoot().sendToDeadLetterQueue(context, node, subscription);
    }

    @Override
    public void sendToDeadLetterQueue(ConnectionContext context, MessageReference node, Subscription subscription) {
        try {
            Message message;
            if (node != null && (message = node.getMessage()) != null && node.getRegionDestination() != null) {
                DeadLetterStrategy deadLetterStrategy = ((Destination)node.getRegionDestination()).getDeadLetterStrategy();
                if (deadLetterStrategy != null) {
                    if (deadLetterStrategy.isSendToDeadLetterQueue(message)) {
                        message = message.copy();
                        this.stampAsExpired(message);
                        message.setExpiration(0L);
                        if (!message.isPersistent()) {
                            message.setPersistent(true);
                            message.setProperty("originalDeliveryMode", "NON_PERSISTENT");
                        }
                        ActiveMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(message, subscription);
                        if (context.getBroker() == null) {
                            context.setBroker(this.getRoot());
                        }
                        BrokerSupport.resendNoCopy(context, message, deadLetterDestination);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Dead Letter message with no DLQ strategy in place, message id: " + message.getMessageId() + ", destination: " + message.getDestination());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Caught an exception sending to DLQ: " + node, (Throwable)e);
        }
    }

    @Override
    public Broker getRoot() {
        try {
            return this.getBrokerService().getBroker();
        }
        catch (Exception e) {
            LOG.error("Trying to get Root Broker " + e);
            throw new RuntimeException("The broker from the BrokerService should not throw an exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBrokerSequenceId() {
        LongSequenceGenerator longSequenceGenerator = this.sequenceGenerator;
        synchronized (longSequenceGenerator) {
            return this.sequenceGenerator.getNextSequenceId();
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        ActiveMQDestination destination = control.getDestination();
        try {
            this.getRegion(destination).processConsumerControl(consumerExchange, control);
        }
        catch (JMSException jmse) {
            LOG.warn("unmatched destination: " + destination + ", in consumerControl: " + control);
        }
    }

    protected void addBrokerInClusterUpdate(BrokerInfo info2) {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients()) continue;
            connector.addPeerBroker(info2);
            connector.updateClientClusterInfo();
        }
    }

    protected void removeBrokerInClusterUpdate(BrokerInfo info2) {
        List<TransportConnector> connectors = this.brokerService.getTransportConnectors();
        for (TransportConnector connector : connectors) {
            if (!connector.isUpdateClusterClients() || !connector.isUpdateClusterClientsOnRemove()) continue;
            connector.removePeerBroker(info2);
            connector.updateClientClusterInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeInactiveDestinations() {
        this.inactiveDestinationsPurgeLock.writeLock().lock();
        try {
            ArrayList<Destination> list = new ArrayList<Destination>();
            Map<ActiveMQDestination, Destination> map2 = this.getDestinationMap();
            if (this.isAllowTempAutoCreationOnSend()) {
                map2.putAll(this.tempQueueRegion.getDestinationMap());
                map2.putAll(this.tempTopicRegion.getDestinationMap());
            }
            long maxPurgedDests = this.brokerService.getMaxPurgedDestinationsPerSweep();
            long timeStamp = System.currentTimeMillis();
            for (Destination d : map2.values()) {
                d.markForGC(timeStamp);
                if (!d.canGC()) continue;
                list.add(d);
                if (maxPurgedDests <= 0L || (long)list.size() != maxPurgedDests) continue;
                break;
            }
            if (!list.isEmpty()) {
                ConnectionContext context = BrokerSupport.getConnectionContext(this);
                context.setBroker(this);
                for (Destination dest : list) {
                    Logger log2 = LOG;
                    if (dest instanceof BaseDestination) {
                        log2 = ((BaseDestination)dest).getLog();
                    }
                    log2.info(dest.getName() + " Inactive for longer than " + dest.getInactiveTimoutBeforeGC() + " ms - removing ...");
                    try {
                        this.getRoot().removeDestination(context, dest.getActiveMQDestination(), this.isAllowTempAutoCreationOnSend() ? 1L : 0L);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to remove inactive destination " + dest, (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.inactiveDestinationsPurgeLock.writeLock().unlock();
        }
    }

    public boolean isAllowTempAutoCreationOnSend() {
        return this.allowTempAutoCreationOnSend;
    }

    public void setAllowTempAutoCreationOnSend(boolean allowTempAutoCreationOnSend) {
        this.allowTempAutoCreationOnSend = allowTempAutoCreationOnSend;
    }
}

