/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.pool.ConnectionKey;
import org.apache.activemq.pool.ConnectionPool;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPoolFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
implements ConnectionFactory,
Service {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnectionFactory.class);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final GenericKeyedObjectPool<ConnectionKey, ConnectionPool> connectionsPool;
    private ConnectionFactory connectionFactory;
    private int maximumActiveSessionPerConnection = 500;
    private int idleTimeout = 30000;
    private boolean blockIfSessionPoolIsFull = true;
    private long expiryTimeout = 0L;
    private boolean createConnectionOnStartup = true;

    public PooledConnectionFactory() {
        this(new ActiveMQConnectionFactory());
    }

    public PooledConnectionFactory(String brokerURL) {
        this(new ActiveMQConnectionFactory(brokerURL));
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.connectionsPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new KeyedPoolableObjectFactory<ConnectionKey, ConnectionPool>(){

            public void activateObject(ConnectionKey key, ConnectionPool connection) throws Exception {
            }

            public void destroyObject(ConnectionKey key, ConnectionPool connection) throws Exception {
                try {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Destroying connection: {}", (Object)connection);
                    }
                    connection.close();
                }
                catch (Exception e) {
                    LOG.warn("Close connection failed for connection: " + connection + ". This exception will be ignored.", (Throwable)e);
                }
            }

            public ConnectionPool makeObject(ConnectionKey key) throws Exception {
                ActiveMQConnection delegate = PooledConnectionFactory.this.createConnection(key);
                ConnectionPool connection = PooledConnectionFactory.this.createConnectionPool(delegate);
                connection.setIdleTimeout(PooledConnectionFactory.this.getIdleTimeout());
                connection.setExpiryTimeout(PooledConnectionFactory.this.getExpiryTimeout());
                connection.setMaximumActiveSessionPerConnection(PooledConnectionFactory.this.getMaximumActiveSessionPerConnection());
                connection.setBlockIfSessionPoolIsFull(PooledConnectionFactory.this.isBlockIfSessionPoolIsFull());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Created new connection: {}", (Object)connection);
                }
                return connection;
            }

            public void passivateObject(ConnectionKey key, ConnectionPool connection) throws Exception {
            }

            public boolean validateObject(ConnectionKey key, ConnectionPool connection) {
                if (connection != null && connection.expiredCheck()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Connection has expired: {} and will be destroyed", (Object)connection);
                    }
                    return false;
                }
                return true;
            }
        });
        this.connectionsPool.setMaxIdle(1);
        this.connectionsPool.setTestOnBorrow(true);
        this.connectionsPool.setTestWhileIdle(true);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public synchronized Connection createConnection(String userName, String password) throws JMSException {
        if (this.stopped.get()) {
            LOG.debug("PooledConnectionFactory is stopped, skip create new connection.");
            return null;
        }
        ConnectionPool connection = null;
        ConnectionKey key = new ConnectionKey(userName, password);
        if (this.connectionsPool.getNumIdle((Object)key) < this.getMaxConnections()) {
            try {
                this.connectionsPool.setLifo(true);
                this.connectionsPool.addObject((Object)key);
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create("Error while attempting to add new Connection to the pool", e);
            }
        } else {
            this.connectionsPool.setLifo(false);
        }
        try {
            connection = (ConnectionPool)this.connectionsPool.borrowObject((Object)key);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Error while attempting to retrieve a connection from the pool", e);
        }
        try {
            this.connectionsPool.returnObject((Object)key, (Object)connection);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Error when returning connection to the pool", e);
        }
        return new PooledConnection(connection);
    }

    public ObjectPoolFactory<?> getPoolFactory() {
        return null;
    }

    protected ActiveMQConnection createConnection(ConnectionKey key) throws JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (ActiveMQConnection)this.connectionFactory.createConnection();
        }
        return (ActiveMQConnection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    @Override
    public void start() {
        LOG.debug("Staring the PooledConnectionFactory: create on start = {}", (Object)this.isCreateConnectionOnStartup());
        this.stopped.set(false);
        if (this.isCreateConnectionOnStartup()) {
            try {
                this.createConnection();
            }
            catch (JMSException e) {
                LOG.warn("Create pooled connection during start failed. This exception will be ignored.", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        LOG.debug("Stopping the PooledConnectionFactory, number of connections in cache: {}", (Object)this.connectionsPool.getNumActive());
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.connectionsPool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void clear() {
        if (this.stopped.get()) {
            return;
        }
        this.connectionsPool.clear();
    }

    @Deprecated
    public int getMaximumActive() {
        return this.getMaximumActiveSessionPerConnection();
    }

    @Deprecated
    public void setMaximumActive(int maximumActive) {
        this.setMaximumActiveSessionPerConnection(maximumActive);
    }

    public int getMaximumActiveSessionPerConnection() {
        return this.maximumActiveSessionPerConnection;
    }

    public void setMaximumActiveSessionPerConnection(int maximumActiveSessionPerConnection) {
        this.maximumActiveSessionPerConnection = maximumActiveSessionPerConnection;
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.blockIfSessionPoolIsFull = block;
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.blockIfSessionPoolIsFull;
    }

    public int getMaxConnections() {
        return this.connectionsPool.getMaxIdle();
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionsPool.setMaxIdle(maxConnections);
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    public boolean isCreateConnectionOnStartup() {
        return this.createConnectionOnStartup;
    }

    public void setCreateConnectionOnStartup(boolean createConnectionOnStartup) {
        this.createConnectionOnStartup = createConnectionOnStartup;
    }

    KeyedObjectPool<ConnectionKey, ConnectionPool> getConnectionsPool() {
        return this.connectionsPool;
    }

    public void setTimeBetweenExpirationCheckMillis(long timeBetweenExpirationCheckMillis) {
        this.connectionsPool.setTimeBetweenEvictionRunsMillis(timeBetweenExpirationCheckMillis);
    }

    public long setTimeBetweenExpirationCheckMillis() {
        return this.connectionsPool.getTimeBetweenEvictionRunsMillis();
    }

    public int getNumConnections() {
        return this.connectionsPool.getNumIdle();
    }

    public void setPoolFactory(ObjectPoolFactory<?> factory) {
    }

    protected ConnectionPool createConnectionPool(ActiveMQConnection connection) {
        return new ConnectionPool(connection);
    }
}

