/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBlobMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.util.ByteSequence;

public class MessageBodyFormatter {
    final ActiveMQMessage message;

    public MessageBodyFormatter(ActiveMQMessage message) {
        this.message = message;
    }

    public String toString() {
        try {
            switch (this.message.getDataStructureType()) {
                case 23: {
                    return "";
                }
                case 29: {
                    ActiveMQBlobMessage blob = (ActiveMQBlobMessage)this.message;
                    return blob.getRemoteBlobUrl();
                }
                case 25: {
                    ActiveMQMapMessage map2 = (ActiveMQMapMessage)this.message;
                    return map2.getContentMap().toString();
                }
                case 28: {
                    ActiveMQTextMessage text = (ActiveMQTextMessage)this.message;
                    return text.getText();
                }
                case 24: 
                case 26: 
                case 27: {
                    ByteSequence data = this.message.getContent();
                    return "binary payload {length=" + data.getLength() + ", compressed=" + this.message.isCompressed() + "}";
                }
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        return "";
    }
}

