/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.broker.SuppressReplyException;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.DefaultIOExceptionHandler;

public class JDBCIOExceptionHandler
extends DefaultIOExceptionHandler {
    public JDBCIOExceptionHandler() {
        this.setIgnoreSQLExceptions(false);
        this.setStopStartConnectors(true);
    }

    @Override
    protected boolean hasLockOwnership() throws IOException {
        JDBCPersistenceAdapter jdbcPersistenceAdapter;
        Locker locker;
        boolean hasLock = true;
        if (this.broker.getPersistenceAdapter() instanceof JDBCPersistenceAdapter && (locker = (jdbcPersistenceAdapter = (JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).getLocker()) != null) {
            try {
                if (!locker.keepAlive()) {
                    hasLock = false;
                }
            }
            catch (SuppressReplyException ignoreWhileHandlingInProgress) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (!hasLock) {
                throw new IOException("Lock keepAlive failed, no longer lock owner with: " + locker);
            }
        }
        return hasLock;
    }
}

