/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.transport.Flow;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportDelivery;
import org.apache.qpid.proton.engine.impl.TransportReceiver;
import org.apache.qpid.proton.engine.impl.TransportSender;

class TransportLink<T extends LinkImpl> {
    private UnsignedInteger _localHandle;
    private String _name;
    private UnsignedInteger _remoteHandle;
    private UnsignedInteger _deliveryCount;
    private UnsignedInteger _linkCredit = UnsignedInteger.ZERO;
    private T _link;
    private UnsignedInteger _remoteDeliveryCount;
    private UnsignedInteger _remoteLinkCredit;
    private boolean _detachReceived;
    private boolean _attachSent;

    protected TransportLink(T link2) {
        this._link = link2;
        this._name = ((LinkImpl)link2).getName();
    }

    static <L extends LinkImpl> TransportLink<L> createTransportLink(L link2) {
        return link2 instanceof ReceiverImpl ? new TransportReceiver((ReceiverImpl)link2) : new TransportSender((SenderImpl)link2);
    }

    public UnsignedInteger getLocalHandle() {
        return this._localHandle;
    }

    public void setLocalHandle(UnsignedInteger localHandle) {
        this._localHandle = localHandle;
    }

    public boolean isLocalHandleSet() {
        return this._localHandle != null;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void clearLocalHandle() {
        this._localHandle = null;
    }

    public UnsignedInteger getRemoteHandle() {
        return this._remoteHandle;
    }

    public void setRemoteHandle(UnsignedInteger remoteHandle) {
        this._remoteHandle = remoteHandle;
    }

    public UnsignedInteger getDeliveryCount() {
        return this._deliveryCount;
    }

    public UnsignedInteger getLinkCredit() {
        return this._linkCredit;
    }

    public void addCredit(int credits) {
        this._linkCredit = UnsignedInteger.valueOf(this._linkCredit.intValue() + credits);
    }

    public boolean hasCredit() {
        return this.getLinkCredit().compareTo(UnsignedInteger.ZERO) > 0;
    }

    public T getLink() {
        return this._link;
    }

    void handleFlow(Flow flow) {
        this._remoteDeliveryCount = flow.getDeliveryCount();
        this._remoteLinkCredit = flow.getLinkCredit();
    }

    void setLinkCredit(UnsignedInteger linkCredit) {
        this._linkCredit = linkCredit;
    }

    public void setDeliveryCount(UnsignedInteger deliveryCount) {
        this._deliveryCount = deliveryCount;
    }

    public void settled(TransportDelivery transportDelivery) {
        ((LinkImpl)this.getLink()).getSession().getTransportSession().settled(transportDelivery);
    }

    UnsignedInteger getRemoteDeliveryCount() {
        return this._remoteDeliveryCount;
    }

    UnsignedInteger getRemoteLinkCredit() {
        return this._remoteLinkCredit;
    }

    public void setRemoteLinkCredit(UnsignedInteger remoteLinkCredit) {
        this._remoteLinkCredit = remoteLinkCredit;
    }

    void decrementLinkCredit() {
        this._linkCredit = this._linkCredit.subtract(UnsignedInteger.ONE);
    }

    void incrementDeliveryCount() {
        this._deliveryCount = this._deliveryCount.add(UnsignedInteger.ONE);
    }

    public void receivedDetach() {
        this._detachReceived = true;
    }

    public boolean detachReceived() {
        return this._detachReceived;
    }

    public boolean attachSent() {
        return this._attachSent;
    }

    public void sentAttach() {
        this._attachSent = true;
    }

    public void setRemoteDeliveryCount(UnsignedInteger remoteDeliveryCount) {
        this._remoteDeliveryCount = remoteDeliveryCount;
    }
}

