/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;

class JobLocation {
    private String jobId;
    private int repeat;
    private long startTime;
    private long delay;
    private long nextTime;
    private long period;
    private String cronEntry;
    private final Location location;

    public JobLocation(Location location) {
        this.location = location;
    }

    public JobLocation() {
        this(new Location());
    }

    public void readExternal(DataInput in) throws IOException {
        this.jobId = in.readUTF();
        this.repeat = in.readInt();
        this.startTime = in.readLong();
        this.delay = in.readLong();
        this.nextTime = in.readLong();
        this.period = in.readLong();
        this.cronEntry = in.readUTF();
        this.location.readExternal(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.jobId);
        out.writeInt(this.repeat);
        out.writeLong(this.startTime);
        out.writeLong(this.delay);
        out.writeLong(this.nextTime);
        out.writeLong(this.period);
        if (this.cronEntry == null) {
            this.cronEntry = "";
        }
        out.writeUTF(this.cronEntry);
        this.location.writeExternal(out);
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long start2) {
        this.startTime = start2;
    }

    public synchronized long getNextTime() {
        return this.nextTime;
    }

    public synchronized void setNextTime(long nextTime) {
        this.nextTime = nextTime;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public synchronized String getCronEntry() {
        return this.cronEntry;
    }

    public synchronized void setCronEntry(String cronEntry) {
        this.cronEntry = cronEntry;
    }

    public boolean isCron() {
        return this.getCronEntry() != null && this.getCronEntry().length() > 0;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return "Job [id=" + this.jobId + ", startTime=" + new Date(this.startTime) + ", delay=" + this.delay + ", period=" + this.period + ", repeat=" + this.repeat + ", nextTime=" + new Date(this.nextTime) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cronEntry == null ? 0 : this.cronEntry.hashCode());
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        result = 31 * result + (this.jobId == null ? 0 : this.jobId.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (int)(this.nextTime ^ this.nextTime >>> 32);
        result = 31 * result + (int)(this.period ^ this.period >>> 32);
        result = 31 * result + this.repeat;
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobLocation other = (JobLocation)obj;
        if (this.cronEntry == null ? other.cronEntry != null : !this.cronEntry.equals(other.cronEntry)) {
            return false;
        }
        if (this.delay != other.delay) {
            return false;
        }
        if (this.jobId == null ? other.jobId != null : !this.jobId.equals(other.jobId)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.nextTime != other.nextTime) {
            return false;
        }
        if (this.period != other.period) {
            return false;
        }
        if (this.repeat != other.repeat) {
            return false;
        }
        return this.startTime == other.startTime;
    }

    static class JobLocationMarshaller
    extends VariableMarshaller<List<JobLocation>> {
        static final JobLocationMarshaller INSTANCE = new JobLocationMarshaller();

        JobLocationMarshaller() {
        }

        @Override
        public List<JobLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<JobLocation> result = new ArrayList<JobLocation>();
            int size2 = dataIn.readInt();
            for (int i = 0; i < size2; ++i) {
                JobLocation jobLocation = new JobLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        @Override
        public void writePayload(List<JobLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (JobLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }
}

