/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class FloatType
extends AbstractPrimitiveType<Float> {
    private FloatEncoding _floatEncoding;

    FloatType(EncoderImpl encoder, DecoderImpl decoder) {
        this._floatEncoding = new FloatEncoding(encoder, decoder);
        encoder.register(Float.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Float> getTypeClass() {
        return Float.class;
    }

    public FloatEncoding getEncoding(Float val) {
        return this._floatEncoding;
    }

    public FloatEncoding getCanonicalEncoding() {
        return this._floatEncoding;
    }

    @Override
    public Collection<FloatEncoding> getAllEncodings() {
        return Collections.singleton(this._floatEncoding);
    }

    @Override
    public void write(float f) {
        this._floatEncoding.write(f);
    }

    public class FloatEncoding
    extends FixedSizePrimitiveTypeEncoding<Float> {
        public FloatEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 4;
        }

        @Override
        public byte getEncodingCode() {
            return 114;
        }

        public FloatType getType() {
            return FloatType.this;
        }

        @Override
        public void writeValue(Float val) {
            this.getEncoder().writeRaw(val.floatValue());
        }

        @Override
        public void writeValue(float val) {
            this.getEncoder().writeRaw(val);
        }

        public void write(float f) {
            this.writeConstructor();
            this.getEncoder().writeRaw(f);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Float> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Float readValue() {
            return Float.valueOf(this.readPrimitiveValue());
        }

        public float readPrimitiveValue() {
            return this.getDecoder().readRawFloat();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }
}

