/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import jakarta.jms.XASession;
import java.io.Serializable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.xa.XAResource;
import org.apache.activemq.jms.pool.PooledMessageConsumer;
import org.apache.activemq.jms.pool.PooledProducer;
import org.apache.activemq.jms.pool.PooledQueueSender;
import org.apache.activemq.jms.pool.PooledSessionEventListener;
import org.apache.activemq.jms.pool.PooledTopicPublisher;
import org.apache.activemq.jms.pool.SessionHolder;
import org.apache.activemq.jms.pool.SessionKey;
import org.apache.commons.pool2.KeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledSession
implements Session,
TopicSession,
QueueSession,
XASession {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledSession.class);
    private final SessionKey key;
    private final KeyedObjectPool<SessionKey, SessionHolder> sessionPool;
    private final CopyOnWriteArrayList<MessageConsumer> consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<QueueBrowser> browsers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<PooledSessionEventListener> sessionEventListeners = new CopyOnWriteArrayList();
    private final AtomicBoolean closed = new AtomicBoolean();
    private SessionHolder sessionHolder;
    private boolean transactional = true;
    private boolean ignoreClose;
    private boolean isXa;
    private boolean useAnonymousProducers = true;

    public PooledSession(SessionKey key, SessionHolder sessionHolder, KeyedObjectPool<SessionKey, SessionHolder> sessionPool, boolean transactional, boolean anonymous) {
        this.key = key;
        this.sessionHolder = sessionHolder;
        this.sessionPool = sessionPool;
        this.transactional = transactional;
        this.useAnonymousProducers = anonymous;
    }

    public void addSessionEventListener(PooledSessionEventListener listener) {
        if (!this.sessionEventListeners.contains(listener)) {
            this.sessionEventListeners.add(listener);
        }
    }

    protected boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    protected void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        if (this.ignoreClose) {
            return;
        }
        if (this.closed.compareAndSet(false, true)) {
            boolean invalidate = false;
            try {
                this.getInternalSession().setMessageListener(null);
                for (MessageConsumer consumer : this.consumers) {
                    consumer.close();
                }
                for (QueueBrowser browser : this.browsers) {
                    browser.close();
                }
                if (this.transactional && !this.isXa) {
                    try {
                        this.getInternalSession().rollback();
                    }
                    catch (JMSException e) {
                        invalidate = true;
                        LOG.warn("Caught exception trying rollback() when putting session back into the pool, will invalidate. " + e, (Throwable)e);
                    }
                }
            }
            catch (JMSException ex) {
                invalidate = true;
                LOG.warn("Caught exception trying close() when putting session back into the pool, will invalidate. " + ex, (Throwable)ex);
            }
            finally {
                this.consumers.clear();
                this.browsers.clear();
                for (PooledSessionEventListener listener : this.sessionEventListeners) {
                    listener.onSessionClosed(this);
                }
                this.sessionEventListeners.clear();
            }
            if (invalidate) {
                if (this.sessionHolder != null) {
                    try {
                        this.sessionHolder.close();
                    }
                    catch (JMSException e1) {
                        LOG.trace("Ignoring exception on close as discarding session: " + e1, (Throwable)e1);
                    }
                }
                try {
                    this.sessionPool.invalidateObject((Object)this.key, (Object)this.sessionHolder);
                }
                catch (Exception e) {
                    LOG.trace("Ignoring exception on invalidateObject as discarding session: " + e, (Throwable)e);
                }
            } else {
                try {
                    this.sessionPool.returnObject((Object)this.key, (Object)this.sessionHolder);
                }
                catch (Exception e) {
                    jakarta.jms.IllegalStateException illegalStateException = new jakarta.jms.IllegalStateException(e.toString());
                    illegalStateException.initCause((Throwable)e);
                    throw illegalStateException;
                }
            }
            this.sessionHolder = null;
        }
    }

    public void commit() throws JMSException {
        this.getInternalSession().commit();
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getInternalSession().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getInternalSession().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getInternalSession().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getInternalSession().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getInternalSession().createObjectMessage(serializable);
    }

    public Queue createQueue(String s) throws JMSException {
        return this.getInternalSession().createQueue(s);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getInternalSession().createStreamMessage();
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        TemporaryQueue result = this.getInternalSession().createTemporaryQueue();
        for (PooledSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryQueueCreate(result);
        }
        return result;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        TemporaryTopic result = this.getInternalSession().createTemporaryTopic();
        for (PooledSessionEventListener listener : this.sessionEventListeners) {
            listener.onTemporaryTopicCreate(result);
        }
        return result;
    }

    public void unsubscribe(String s) throws JMSException {
        this.getInternalSession().unsubscribe(s);
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getInternalSession().createTextMessage();
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        return this.getInternalSession().createTextMessage(s);
    }

    public Topic createTopic(String s) throws JMSException {
        return this.getInternalSession().createTopic(s);
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.getInternalSession().getAcknowledgeMode();
    }

    public boolean getTransacted() throws JMSException {
        return this.getInternalSession().getTransacted();
    }

    public void recover() throws JMSException {
        this.getInternalSession().recover();
    }

    public void rollback() throws JMSException {
        this.getInternalSession().rollback();
    }

    public XAResource getXAResource() {
        SessionHolder session = this.safeGetSessionHolder();
        if (session.getSession() instanceof XASession) {
            return ((XASession)session.getSession()).getXAResource();
        }
        return null;
    }

    public Session getSession() {
        return this;
    }

    public void run() {
        SessionHolder session = this.safeGetSessionHolder();
        if (session != null) {
            session.getSession().run();
        }
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue));
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return this.addQueueBrowser(this.getInternalSession().createBrowser(queue, selector));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination));
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector));
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        return this.addConsumer(this.getInternalSession().createConsumer(destination, selector, noLocal));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String selector) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, selector));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        return this.addTopicSubscriber(this.getInternalSession().createDurableSubscriber(topic, name, selector, noLocal));
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getInternalSession().getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getInternalSession().setMessageListener(messageListener);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return this.addTopicSubscriber(((TopicSession)this.getInternalSession()).createSubscriber(topic));
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        return this.addTopicSubscriber(((TopicSession)this.getInternalSession()).createSubscriber(topic, selector, local));
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.addQueueReceiver(((QueueSession)this.getInternalSession()).createReceiver(queue));
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        return this.addQueueReceiver(((QueueSession)this.getInternalSession()).createReceiver(queue, selector));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        throw new UnsupportedOperationException("createSharedConsumer(Topic, sharedSubscriptionName) is not supported");
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException("createSharedConsumer(Topic, sharedSubscriptionName, messageSelector) is not supported");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException("createDurableConsumer(Topic, name) is not supported");
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        throw new UnsupportedOperationException("createDurableConsumer(Topic, name, messageSelector, noLocal) is not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        throw new UnsupportedOperationException("createSharedDurableConsumer(Topic, name) is not supported");
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        throw new UnsupportedOperationException("createSharedDurableConsumer(Topic, name, messageSelector) is not supported");
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return new PooledProducer(this.getMessageProducer(destination), destination);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return new PooledQueueSender(this.getQueueSender(queue), (Destination)queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return new PooledTopicPublisher(this.getTopicPublisher(topic), (Destination)topic);
    }

    public Session getInternalSession() throws IllegalStateException {
        return this.safeGetSessionHolder().getSession();
    }

    public MessageProducer getMessageProducer() throws JMSException {
        return this.getMessageProducer(null);
    }

    public MessageProducer getMessageProducer(Destination destination) throws JMSException {
        MessageProducer result = null;
        result = this.useAnonymousProducers ? this.safeGetSessionHolder().getOrCreateProducer() : this.getInternalSession().createProducer(destination);
        return result;
    }

    public QueueSender getQueueSender() throws JMSException {
        return this.getQueueSender(null);
    }

    public QueueSender getQueueSender(Queue destination) throws JMSException {
        QueueSender result = null;
        result = this.useAnonymousProducers ? this.safeGetSessionHolder().getOrCreateSender() : ((QueueSession)this.getInternalSession()).createSender(destination);
        return result;
    }

    public TopicPublisher getTopicPublisher() throws JMSException {
        return this.getTopicPublisher(null);
    }

    public TopicPublisher getTopicPublisher(Topic destination) throws JMSException {
        TopicPublisher result = null;
        result = this.useAnonymousProducers ? this.safeGetSessionHolder().getOrCreatePublisher() : ((TopicSession)this.getInternalSession()).createPublisher(destination);
        return result;
    }

    private QueueBrowser addQueueBrowser(QueueBrowser browser) {
        this.browsers.add(browser);
        return browser;
    }

    private MessageConsumer addConsumer(MessageConsumer consumer) {
        this.consumers.add(consumer);
        return new PooledMessageConsumer(this, consumer);
    }

    private TopicSubscriber addTopicSubscriber(TopicSubscriber subscriber) {
        this.consumers.add((MessageConsumer)subscriber);
        return subscriber;
    }

    private QueueReceiver addQueueReceiver(QueueReceiver receiver) {
        this.consumers.add((MessageConsumer)receiver);
        return receiver;
    }

    public void setIsXa(boolean isXa) {
        this.isXa = isXa;
    }

    public String toString() {
        return "PooledSession { " + this.safeGetSessionHolder() + " }";
    }

    protected void onConsumerClose(MessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    private SessionHolder safeGetSessionHolder() {
        SessionHolder sessionHolder = this.sessionHolder;
        if (sessionHolder == null) {
            throw new IllegalStateException("The session has already been closed");
        }
        return sessionHolder;
    }
}

