/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import jakarta.jms.Connection;
import java.io.IOException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.JcaConnectionPool;
import org.apache.activemq.pool.XaPooledConnectionFactory;
import org.apache.activemq.transport.TransportListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcaPooledConnectionFactory
extends XaPooledConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(JcaPooledConnectionFactory.class);
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new JcaConnectionPool(connection, this.getTransactionManager(), this.getName()){

            @Override
            protected Connection wrap(final Connection connection) {
                ((ActiveMQConnection)connection).addTransportListener(new TransportListener(){

                    @Override
                    public void onCommand(Object command) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onException(IOException error) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.setHasExpired(true);
                            if (!JcaPooledConnectionFactory.this.stopped.get()) {
                                LOG.info("Expiring connection " + connection + " on IOException: " + error.getMessage());
                                LOG.debug("Expiring connection " + connection + " on IOException: ", (Throwable)error);
                            }
                        }
                    }

                    @Override
                    public void transportInterupted() {
                    }

                    @Override
                    public void transportResumed() {
                    }
                });
                this.setHasExpired(((ActiveMQConnection)connection).isTransportFailed());
                return connection;
            }

            @Override
            protected void unWrap(Connection connection) {
                if (connection != null) {
                    ((ActiveMQConnection)connection).cleanUpTempDestinations();
                }
            }
        };
    }
}

