/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import jakarta.jms.JMSException;
import jakarta.jms.MessageFormatException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.amqp.message.AmqpMessageSupport;
import org.apache.activemq.transport.amqp.message.AmqpWritableBuffer;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.OutboundTransformer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.ProtonJMessage;

public class AMQPNativeOutboundTransformer
implements OutboundTransformer {
    @Override
    public EncodedMessage transform(ActiveMQMessage message) throws Exception {
        if (message == null || !(message instanceof ActiveMQBytesMessage)) {
            return null;
        }
        return AMQPNativeOutboundTransformer.transform(this, (ActiveMQBytesMessage)message);
    }

    static EncodedMessage transform(OutboundTransformer options, ActiveMQBytesMessage message) throws JMSException {
        long messageFormat;
        if (message.propertyExists("JMS_AMQP_MESSAGE_FORMAT")) {
            try {
                messageFormat = message.getLongProperty("JMS_AMQP_MESSAGE_FORMAT");
            }
            catch (MessageFormatException e) {
                return null;
            }
        } else {
            messageFormat = 0L;
        }
        Binary encodedMessage = AmqpMessageSupport.getBinaryFromMessageBody(message);
        byte[] encodedData = encodedMessage.getArray();
        int encodedSize = encodedMessage.getLength();
        int count = message.getRedeliveryCounter();
        if (count >= 1) {
            int decoded;
            ProtonJMessage amqp = (ProtonJMessage)Message.Factory.create();
            int offset = 0;
            for (int len = encodedSize; len > 0; len -= decoded) {
                decoded = amqp.decode(encodedData, offset, len);
                assert (decoded > 0) : "Make progress decoding the message";
                offset += decoded;
            }
            if (amqp.getHeader() == null) {
                amqp.setHeader(new Header());
            }
            amqp.getHeader().setDeliveryCount(new UnsignedInteger(count));
            AmqpWritableBuffer buffer = new AmqpWritableBuffer();
            int written = amqp.encode(buffer);
            encodedData = buffer.getArray();
            encodedSize = written;
        }
        return new EncodedMessage(messageFormat, encodedData, 0, encodedSize);
    }
}

