/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.leveldb.LevelDBPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.util.JMXSupport;

public abstract class TestSupport
extends CombinationTestSupport {
    protected ActiveMQConnectionFactory connectionFactory;
    protected boolean topic = true;
    public PersistenceAdapterChoice defaultPersistenceAdapter = PersistenceAdapterChoice.KahaDB;

    protected ActiveMQMessage createMessage() {
        return new ActiveMQMessage();
    }

    protected javax.jms.Destination createDestination(String subject) {
        if (this.topic) {
            return new ActiveMQTopic(subject);
        }
        return new ActiveMQQueue(subject);
    }

    protected javax.jms.Destination createDestination() {
        return this.createDestination(this.getDestinationString());
    }

    protected String getDestinationString() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName(true);
    }

    protected void assertTextMessagesEqual(String messsage, Message[] firstSet, Message[] secondSet) throws JMSException {
        TestSupport.assertEquals((String)("Message count does not match: " + messsage), (int)firstSet.length, (int)secondSet.length);
        for (int i = 0; i < secondSet.length; ++i) {
            TextMessage m1 = (TextMessage)firstSet[i];
            TextMessage m2 = (TextMessage)secondSet[i];
            TestSupport.assertFalse((String)("Message " + (i + 1) + " did not match : " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"), (boolean)(m1 == null ^ m2 == null));
            TestSupport.assertEquals((String)("Message " + (i + 1) + " did not match: " + messsage + ": expected {" + m1 + "}, but was {" + m2 + "}"), (String)m1.getText(), (String)m2.getText());
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }

    protected Connection createConnection() throws Exception {
        return this.getConnectionFactory().createConnection();
    }

    public ActiveMQConnectionFactory getConnectionFactory() throws Exception {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.createConnectionFactory();
            TestSupport.assertTrue((String)"Should have created a connection factory!", (this.connectionFactory != null ? 1 : 0) != 0);
        }
        return this.connectionFactory;
    }

    protected String getConsumerSubject() {
        return this.getSubject();
    }

    protected String getProducerSubject() {
        return this.getSubject();
    }

    protected String getSubject() {
        return this.getName();
    }

    public static void recursiveDelete(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                TestSupport.recursiveDelete(files[i]);
            }
        }
        f.delete();
    }

    public static void removeMessageStore() {
        if (System.getProperty("activemq.store.dir") != null) {
            TestSupport.recursiveDelete(new File(System.getProperty("activemq.store.dir")));
        }
        if (System.getProperty("derby.system.home") != null) {
            TestSupport.recursiveDelete(new File(System.getProperty("derby.system.home")));
        }
    }

    public static DestinationStatistics getDestinationStatistics(BrokerService broker, ActiveMQDestination destination) {
        DestinationStatistics result = null;
        Destination dest = TestSupport.getDestination(broker, destination);
        if (dest != null) {
            result = dest.getDestinationStatistics();
        }
        return result;
    }

    public static List<Subscription> getDestinationConsumers(BrokerService broker, ActiveMQDestination destination) {
        List result = null;
        Destination dest = TestSupport.getDestination(broker, destination);
        if (dest != null) {
            result = dest.getConsumers();
        }
        return result;
    }

    public static Destination getDestination(BrokerService target, ActiveMQDestination destination) {
        Destination result = null;
        for (Destination dest : TestSupport.getDestinationMap(target, destination).values()) {
            if (!dest.getName().equals(destination.getPhysicalName())) continue;
            result = dest;
            break;
        }
        return result;
    }

    private static Map<ActiveMQDestination, Destination> getDestinationMap(BrokerService target, ActiveMQDestination destination) {
        RegionBroker regionBroker = (RegionBroker)target.getRegionBroker();
        if (destination.isTemporary()) {
            return destination.isQueue() ? regionBroker.getTempQueueRegion().getDestinationMap() : regionBroker.getTempTopicRegion().getDestinationMap();
        }
        return destination.isQueue() ? regionBroker.getQueueRegion().getDestinationMap() : regionBroker.getTopicRegion().getDestinationMap();
    }

    protected QueueViewMBean getProxyToQueue(String name) throws MalformedObjectNameException, JMSException {
        BrokerService brokerService = BrokerRegistry.getInstance().lookup("localhost");
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + JMXSupport.encodeObjectNamePart((String)name));
        QueueViewMBean proxy = (QueueViewMBean)brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    public PersistenceAdapter setDefaultPersistenceAdapter(BrokerService broker) throws IOException {
        return TestSupport.setPersistenceAdapter(broker, this.defaultPersistenceAdapter);
    }

    public static PersistenceAdapter setPersistenceAdapter(BrokerService broker, PersistenceAdapterChoice choice) throws IOException {
        KahaDBPersistenceAdapter adapter = null;
        switch (choice) {
            case JDBC: {
                JDBCPersistenceAdapter jdbcPersistenceAdapter = new JDBCPersistenceAdapter();
                jdbcPersistenceAdapter.setUseLock(false);
                adapter = jdbcPersistenceAdapter;
                break;
            }
            case KahaDB: {
                adapter = new KahaDBPersistenceAdapter();
                break;
            }
            case LevelDB: {
                adapter = new LevelDBPersistenceAdapter();
                break;
            }
            case MEM: {
                adapter = new MemoryPersistenceAdapter();
            }
        }
        broker.setPersistenceAdapter(adapter);
        adapter.setDirectory(new File(broker.getBrokerDataDirectory(), choice.name()));
        return adapter;
    }

    public void stopBrokerWithStoreFailure(BrokerService broker, PersistenceAdapterChoice choice) throws Exception {
        switch (choice) {
            case KahaDB: {
                KahaDBPersistenceAdapter kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)broker.getPersistenceAdapter();
                kahaDBPersistenceAdapter.getStore().getJournal().close();
                break;
            }
            default: {
                broker.stop();
            }
        }
        broker.waitUntilStopped();
    }

    protected void assertBaseDirectoryContainsSpaces() {
        TestSupport.assertFalse((String)"Base directory cannot contain spaces.", (boolean)new File(System.getProperty("basedir", ".")).getAbsoluteFile().toString().contains(" "));
    }

    public void safeCloseConnection(Connection c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public static enum PersistenceAdapterChoice {
        LevelDB,
        KahaDB,
        JDBC,
        MEM;

    }
}

