/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CursorMemoryHighWaterMarkTest {
    private static final Logger LOG = LoggerFactory.getLogger(CursorMemoryHighWaterMarkTest.class);
    public static final String MY_QUEUE_2 = "myQueue_2";
    public static final String MY_QUEUE = "myQueue";
    public static final String BROKER_NAME = "myBroker";
    private BrokerService broker1;
    private ActiveMQConnectionFactory connectionFactory;

    @Before
    public void setUp() throws Exception {
        this.broker1 = this.createAndStartBroker(BROKER_NAME);
        this.broker1.waitUntilStarted();
        this.connectionFactory = new ActiveMQConnectionFactory("vm://myBroker");
    }

    private BrokerService createAndStartBroker(String name) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setBrokerName(name);
        broker.setUseJmx(true);
        broker.getSystemUsage().getMemoryUsage().setLimit(5000000L);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setMemoryLimit(1024000L);
        policy.setCursorMemoryHighWaterMark(50);
        policyMap.put((ActiveMQDestination)new ActiveMQQueue(MY_QUEUE_2), (Object)policy);
        broker.setDestinationPolicy(policyMap);
        broker.start();
        return broker;
    }

    @After
    public void tearDown() throws Exception {
        this.broker1.stop();
    }

    @Test
    public void testCursorHighWaterMark() throws Exception {
        int systemUsage = this.broker1.getSystemUsage().getMemoryUsage().getPercentUsage();
        Assert.assertEquals((String)"System Usage on broker1 before test", (long)0L, (long)systemUsage);
        this.produceMesssages(MY_QUEUE, 3000);
        systemUsage = this.broker1.getSystemUsage().getMemoryUsage().getPercentUsage();
        junit.framework.Assert.assertTrue((String)"System Usage on broker1 before test", (60 < systemUsage ? 1 : 0) != 0);
        LOG.info("Broker System Mem Usage: " + this.broker1.getSystemUsage().getMemoryUsage());
        this.produceMesssages(MY_QUEUE_2, 1);
        this.consume(MY_QUEUE_2, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceMesssages(String queue, int messageCount) throws Exception {
        try (Connection con = this.connectionFactory.createConnection();){
            con.start();
            Session session = con.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(queue));
            String textMessage = this.getTextForMessage();
            TextMessage msg = session.createTextMessage(textMessage);
            for (int i = 0; i < messageCount; ++i) {
                producer.send((Message)msg);
            }
        }
    }

    private String getTextForMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i > 10000; ++i) {
            stringBuffer.append("0123456789");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consume(String queue, int messageCount) throws Exception {
        try (Connection con = this.connectionFactory.createConnection();){
            con.start();
            Session session = con.createSession(false, 1);
            MessageConsumer messageConsumer = session.createConsumer((Destination)session.createQueue(queue));
            for (int i = 0; i < messageCount; ++i) {
                Message message = messageConsumer.receive(5000L);
                if (message != null) continue;
                Assert.fail((String)"should have received a message");
            }
        }
    }
}

