/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMTransportClosureTest
extends EmbeddedBrokerTestSupport {
    private static final Log LOG = LogFactory.getLog(VMTransportClosureTest.class);
    private static final long MAX_TEST_TIME_MILLIS = 300000L;
    private static final int NUM_ATTEMPTS = 100000;

    @Override
    public void setUp() throws Exception {
        this.setAutoFail(true);
        this.setMaxTestTime(300000L);
        super.setUp();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(this.isPersistent());
        return answer;
    }

    public void testPrematureClosure() throws Exception {
        ActiveMQConnection persistentConn = (ActiveMQConnection)this.createConnection();
        persistentConn.start();
        Session session = persistentConn.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        for (int i = 0; i < 100000; ++i) {
            LOG.info((Object)("Attempt: " + i));
            final Transport localTransport = TransportFactory.connect((URI)this.broker.getVmConnectorURI());
            localTransport.setTransportListener(new TransportListener(){

                public void onCommand(Object command) {
                    if (command instanceof ShutdownInfo) {
                        try {
                            localTransport.stop();
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }

                public void onException(IOException error) {
                }

                public void transportInterupted() {
                }

                public void transportResumed() {
                }
            });
            localTransport.start();
            localTransport.stop();
            producer.send(session.createMessage());
            session.rollback();
        }
        persistentConn.close();
    }
}

