/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Message;
import org.apache.activemq.network.BaseNetworkTest;
import org.apache.activemq.network.BridgeFactory;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.transport.Transport;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CustomBridgeFactoryTest
extends BaseNetworkTest {
    private ActiveMQQueue outgoing = new ActiveMQQueue("outgoing");

    @Test
    public void verifyOutgoingCommunication() throws JMSException {
        CustomNetworkBridgeFactory bridgeFactory = this.getCustomNetworkBridgeFactory();
        NetworkBridgeListener listener = bridgeFactory.getListener();
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onStart((NetworkBridge)Matchers.any(NetworkBridge.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
        this.send(this.localSession, this.outgoing, this.localSession.createTextMessage("test message"));
        Assert.assertNotNull((String)"Message didn't arrive", (Object)this.receive(this.remoteSession, this.outgoing));
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onOutboundMessage((NetworkBridge)Matchers.any(NetworkBridge.class), (Message)Matchers.any(Message.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    @Test
    public void verifyBrokerShutdown() {
        this.shutdownTest(() -> {
            try {
                this.localBroker.stop();
            }
            catch (Exception e) {
                return e;
            }
            return null;
        });
    }

    @Test
    public void verifyConnectorShutdown() {
        this.shutdownTest(() -> {
            try {
                this.getLocalConnector(0).stop();
            }
            catch (Exception e) {
                return e;
            }
            return null;
        });
    }

    private void shutdownTest(Supplier<Throwable> callback) {
        CustomNetworkBridgeFactory bridgeFactory = this.getCustomNetworkBridgeFactory();
        NetworkBridgeListener listener = bridgeFactory.getListener();
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onStart((NetworkBridge)Matchers.any(NetworkBridge.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
        Throwable throwable = callback.get();
        Assert.assertNull((String)"Unexpected error", (Object)throwable);
        ((NetworkBridgeListener)Mockito.verify((Object)listener)).onStop((NetworkBridge)Matchers.any(NetworkBridge.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Session session, ActiveMQQueue destination, TextMessage message) throws JMSException {
        try (MessageProducer producer = session.createProducer((Destination)destination);){
            producer.send((javax.jms.Message)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private javax.jms.Message receive(Session session, ActiveMQQueue destination) throws JMSException {
        try (MessageConsumer consumer = session.createConsumer((Destination)destination);){
            javax.jms.Message message = consumer.receive(TimeUnit.SECONDS.toMillis(5L));
            return message;
        }
    }

    private CustomNetworkBridgeFactory getCustomNetworkBridgeFactory() {
        NetworkConnector connector = this.getLocalConnector(0);
        Assert.assertTrue((boolean)(connector.getBridgeFactory() instanceof CustomNetworkBridgeFactory));
        return (CustomNetworkBridgeFactory)connector.getBridgeFactory();
    }

    private NetworkConnector getLocalConnector(int index) {
        return (NetworkConnector)this.localBroker.getNetworkConnectors().get(index);
    }

    @Override
    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/localBroker-custom-factory.xml";
    }

    static class CompositeNetworkBridgeListener
    implements NetworkBridgeListener {
        private final List<NetworkBridgeListener> listeners;

        public CompositeNetworkBridgeListener(NetworkBridgeListener ... wrapped) {
            this.listeners = Arrays.asList(wrapped);
        }

        public void bridgeFailed() {
            for (NetworkBridgeListener listener : this.listeners) {
                listener.bridgeFailed();
            }
        }

        public void onStart(NetworkBridge bridge) {
            for (NetworkBridgeListener listener : this.listeners) {
                listener.onStart(bridge);
            }
        }

        public void onStop(NetworkBridge bridge) {
            for (NetworkBridgeListener listener : this.listeners) {
                listener.onStop(bridge);
            }
        }

        public void onOutboundMessage(NetworkBridge bridge, Message message) {
            for (NetworkBridgeListener listener : this.listeners) {
                listener.onOutboundMessage(bridge, message);
            }
        }

        public void onInboundMessage(NetworkBridge bridge, Message message) {
            for (NetworkBridgeListener listener : this.listeners) {
                listener.onInboundMessage(bridge, message);
            }
        }
    }

    static class CustomNetworkBridgeFactory
    implements BridgeFactory {
        private final NetworkBridgeListener listener;

        CustomNetworkBridgeFactory() {
            this((NetworkBridgeListener)Mockito.mock(NetworkBridgeListener.class));
        }

        CustomNetworkBridgeFactory(NetworkBridgeListener listener) {
            this.listener = listener;
        }

        public NetworkBridgeListener getListener() {
            return this.listener;
        }

        public DemandForwardingBridge createNetworkBridge(NetworkBridgeConfiguration configuration, Transport localTransport, Transport remoteTransport, NetworkBridgeListener listener) {
            DemandForwardingBridge bridge = new DemandForwardingBridge(configuration, localTransport, remoteTransport);
            bridge.setNetworkBridgeListener((NetworkBridgeListener)new CompositeNetworkBridgeListener(this.listener, listener));
            return bridge;
        }
    }
}

