/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkConnector;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasDualAuthenticationNetworkBridgeTest {
    protected String CONFIG_FILE = "org/apache/activemq/security/JaasDualAuthenticationNetworkBridge.xml";
    protected static Logger LOG = LoggerFactory.getLogger(JaasDualAuthenticationNetworkBridgeTest.class);
    private BrokerService broker1 = null;
    private BrokerService broker2 = null;

    @Before
    public void setUp() throws Exception {
        LOG.info("Starting up");
        String path = null;
        URL resource = JaasDualAuthenticationNetworkBridgeTest.class.getClassLoader().getResource("login-JaasDualAuthenticationNetworkBridge.config");
        if (resource != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
        LOG.info("Path to login config: " + path);
        try {
            ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(this.CONFIG_FILE);
            this.broker1 = (BrokerService)context.getBean("broker1");
            this.broker2 = (BrokerService)context.getBean("broker2");
        }
        catch (Exception e) {
            LOG.error("Error: " + e.getMessage());
            throw e;
        }
        this.broker2.start();
        this.broker1.start();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Shutting down");
        if (this.broker1 != null && this.broker1.isStarted()) {
            LOG.info("Broker still running, stopping it now.");
            this.broker1.stop();
        } else {
            LOG.info("Broker1 not running, nothing to shutdown.");
        }
        if (this.broker2 != null && this.broker2.isStarted()) {
            LOG.info("Broker still running, stopping it now.");
            this.broker2.stop();
        } else {
            LOG.info("Broker2 not running, nothing to shutdown.");
        }
    }

    @Test
    public void testNetworkBridgeUsingJaasDualAuthenticationPlugin() throws Exception {
        LOG.info("testNetworkBridgeUsingJaasDualAuthenticationPlugin() called.");
        try {
            Thread.sleep(5000L);
            Assert.assertNotNull((Object)this.broker1);
            List ncs = this.broker1.getNetworkConnectors();
            Assert.assertNotNull((String)"Network Connector not found.", (Object)ncs);
            Assert.assertFalse((String)"Network Connector not found.", (boolean)ncs.isEmpty());
            NetworkConnector nc = (NetworkConnector)ncs.get(0);
            Collection bridges = nc.activeBridges();
            Assert.assertFalse((String)"Network bridge not established to broker 2", (boolean)bridges.isEmpty());
            Assert.assertTrue((String)"Network bridge not established to broker 2", (bridges.size() == 1 ? 1 : 0) != 0);
            for (NetworkBridge nb : bridges) {
                Assert.assertTrue((nb.getRemoteBrokerId() != null ? 1 : 0) != 0);
            }
            LOG.info("Network bridge is correctly established.");
        }
        catch (InterruptedException ex) {
            LOG.warn(ex.getMessage());
        }
    }
}

