/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.spring.SpringTestSupport;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringTest
extends SpringTestSupport {
    public void testSenderWithSpringXml() throws Exception {
        String config = "spring.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlAndQueue() throws Exception {
        String config = "spring-queue.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlUsingJNDI() throws Exception {
        String config = "spring-jndi.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlEmbeddedBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlUsingSpring2NamespacesWithEmbeddedBrokerConfiguredViaXml() throws Exception {
        String config = "spring-embedded-xbean.xml";
        this.assertSenderConfig(config);
    }

    public void testSenderWithSpringXmlUsingSpring2NamespacesWithEmbeddedBrokerConfiguredViaXmlUsingLocalXsd() throws Exception {
        String config = "spring-embedded-xbean-local.xml";
        this.assertSenderConfig(config);
    }

    public void testStartFalse() throws Exception {
        String config = "spring-start-false.xml";
        Thread.currentThread().setContextClassLoader(SpringTest.class.getClassLoader());
        this.context = new ClassPathXmlApplicationContext(config);
        BrokerService broker = (BrokerService)this.context.getBean(BrokerService.class);
        SpringTest.assertFalse((String)"Broker is started", (boolean)broker.isStarted());
    }
}

