/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.store.AbstractMessageStoreSizeStatTest;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiKahaDBMessageStoreSizeStatTest
extends AbstractMessageStoreSizeStatTest {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiKahaDBMessageStoreSizeStatTest.class);
    @Rule
    public TemporaryFolder dataFileDir = new TemporaryFolder(new File("target"));

    @Override
    protected void setUpBroker(boolean clearDataDir) throws Exception {
        if (clearDataDir && this.dataFileDir.getRoot().exists()) {
            FileUtils.cleanDirectory((File)this.dataFileDir.getRoot());
        }
        super.setUpBroker(clearDataDir);
    }

    @Override
    protected void initPersistence(BrokerService brokerService) throws IOException {
        this.broker.setPersistent(true);
        MultiKahaDBPersistenceAdapter persistenceAdapter = new MultiKahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(this.dataFileDir.getRoot());
        KahaDBPersistenceAdapter kahaStore = new KahaDBPersistenceAdapter();
        kahaStore.setJournalMaxFileLength(524288);
        FilteredKahaDBPersistenceAdapter filtered = new FilteredKahaDBPersistenceAdapter();
        filtered.setPersistenceAdapter((PersistenceAdapter)kahaStore);
        filtered.setPerDestination(true);
        ArrayList<FilteredKahaDBPersistenceAdapter> stores = new ArrayList<FilteredKahaDBPersistenceAdapter>();
        stores.add(filtered);
        persistenceAdapter.setFilteredPersistenceAdapters(stores);
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
    }

    @Test(timeout=60000L)
    public void testMessageSizeAfterRestartAndPublish() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        Destination dest = this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyStats(dest, 200, publishedMessageSize.get());
        this.stopBroker();
        this.setUpBroker(false);
        dest = this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyStats(dest, 400, publishedMessageSize.get());
    }

    @Test(timeout=60000L)
    public void testMessageSizeAfterRestartAndPublishMultiQueue() throws Exception {
        AtomicLong publishedMessageSize = new AtomicLong();
        AtomicLong publishedMessageSize2 = new AtomicLong();
        Destination dest = this.publishTestQueueMessages(200, publishedMessageSize);
        this.verifyStats(dest, 200, publishedMessageSize.get());
        Assert.assertTrue((this.broker.getPersistenceAdapter().size() > publishedMessageSize.get() ? 1 : 0) != 0);
        Destination dest2 = this.publishTestQueueMessages(200, "test.queue2", publishedMessageSize2);
        this.verifyStats(dest2, 200, publishedMessageSize2.get());
        Assert.assertTrue((this.broker.getPersistenceAdapter().size() > publishedMessageSize.get() + publishedMessageSize2.get() ? 1 : 0) != 0);
        this.stopBroker();
        this.setUpBroker(false);
        dest = this.publishTestQueueMessages(200, publishedMessageSize);
        dest2 = this.publishTestQueueMessages(200, "test.queue2", publishedMessageSize2);
        this.verifyStats(dest, 400, publishedMessageSize.get());
        this.verifyStats(dest2, 400, publishedMessageSize2.get());
        Assert.assertTrue((this.broker.getPersistenceAdapter().size() > publishedMessageSize.get() + publishedMessageSize2.get() ? 1 : 0) != 0);
        Assert.assertTrue((this.broker.getPersistenceAdapter().size() >= dest.getMessageStore().getMessageSize() + dest2.getMessageStore().getMessageSize() ? 1 : 0) != 0);
    }
}

