/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.leveldb;

import java.io.File;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTest;
import org.apache.activemq.leveldb.LevelDBStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.IOHelper;

public class LevelDBStoreBrokerTest
extends BrokerTest {
    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        super.setUp();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        LevelDBStore levelDBStore = new LevelDBStore();
        File directory = new File("target/activemq-data/leveldb");
        IOHelper.deleteChildren((File)directory);
        levelDBStore.setDirectory(directory);
        levelDBStore.deleteAllMessages();
        broker.setPersistenceAdapter((PersistenceAdapter)levelDBStore);
        return broker;
    }

    protected BrokerService createRestartedBroker() throws Exception {
        BrokerService broker = new BrokerService();
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("target/activemq-data/leveldb"));
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        return broker;
    }

    public static Test suite() {
        return LevelDBStoreBrokerTest.suite(LevelDBStoreBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LevelDBStoreBrokerTest.suite());
    }
}

