/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.junit.After;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ConnectionHangOnStartupTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectionHangOnStartupTest.class);
    protected String uriString = "failover://(tcp://localhost:62001?wireFormat.maxInactivityDurationInitalDelay=1,tcp://localhost:62002?wireFormat.maxInactivityDurationInitalDelay=1)?randomize=false&maxReconnectDelay=200";
    protected BrokerService master = null;
    protected AtomicReference<BrokerService> slave = new AtomicReference();

    @After
    public void tearDown() throws Exception {
        BrokerService brokerService = this.slave.get();
        if (brokerService != null) {
            brokerService.stop();
        }
        if (this.master != null) {
            this.master.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.uriString);
    }

    protected void createMaster() throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getMasterXml()));
        brokerFactory.afterPropertiesSet();
        this.master = brokerFactory.getBroker();
        this.master.start();
    }

    protected void createSlave() throws Exception {
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getSlaveXml()));
        brokerFactory.afterPropertiesSet();
        BrokerService broker = brokerFactory.getBroker();
        broker.start();
        this.slave.set(broker);
    }

    protected String getSlaveXml() {
        return "org/apache/activemq/broker/ft/sharedFileSlave.xml";
    }

    protected String getMasterXml() {
        return "org/apache/activemq/broker/ft/sharedFileMaster.xml";
    }

    @Test(timeout=60000L)
    public void testInitialWireFormatNegotiationTimeout() throws Exception {
        final AtomicReference conn = new AtomicReference();
        final CountDownLatch connStarted = new CountDownLatch(1);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    conn.set(ConnectionHangOnStartupTest.this.createConnectionFactory().createConnection());
                    ((Connection)conn.get()).start();
                }
                catch (Exception ex) {
                    LOG.error("could not create or start connection", (Throwable)ex);
                }
                connStarted.countDown();
            }
        };
        t.start();
        this.createMaster();
        ((Connection)conn.get()).stop();
    }
}

