/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.net.URI;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverTransportBackupsTest {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverTransportBackupsTest.class);
    protected Transport transport;
    protected FailoverTransport failoverTransport;
    private int transportInterruptions;
    private int transportResumptions;
    BrokerService broker1;
    BrokerService broker2;
    BrokerService broker3;
    BrokerInfo currentBrokerInfo;

    @Before
    public void setUp() throws Exception {
        this.broker1 = this.createBroker("1");
        this.broker2 = this.createBroker("2");
        this.broker3 = this.createBroker("3");
        this.broker1.start();
        this.broker2.start();
        this.broker3.start();
        this.broker1.waitUntilStarted();
        this.broker2.waitUntilStarted();
        this.broker3.waitUntilStarted();
        this.transportInterruptions = 0;
        this.transportResumptions = 0;
    }

    @After
    public void tearDown() throws Exception {
        if (this.transport != null) {
            this.transport.stop();
        }
        this.broker1.stop();
        this.broker1.waitUntilStopped();
        this.broker2.stop();
        this.broker2.waitUntilStopped();
        this.broker3.stop();
        this.broker3.waitUntilStopped();
    }

    @Test
    public void testBackupsAreCreated() throws Exception {
        this.transport = this.createTransport(2);
        Assert.assertNotNull((Object)this.failoverTransport);
        Assert.assertTrue((boolean)this.failoverTransport.isBackup());
        Assert.assertEquals((long)2L, (long)this.failoverTransport.getBackupPoolSize());
        Assert.assertTrue((String)"Timed out waiting for Backups to connect.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.debug("Current Backup Count = " + FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups());
                return FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups() == 2;
            }
        }));
    }

    @Test
    public void testFailoverToBackups() throws Exception {
        this.transport = this.createTransport(2);
        Assert.assertNotNull((Object)this.failoverTransport);
        Assert.assertTrue((boolean)this.failoverTransport.isBackup());
        Assert.assertEquals((long)2L, (long)this.failoverTransport.getBackupPoolSize());
        Assert.assertTrue((String)"Timed out waiting for Backups to connect.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.debug("Current Backup Count = " + FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups());
                return FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups() == 2;
            }
        }));
        Assert.assertEquals((String)"conected to..", (Object)"1", (Object)this.currentBrokerInfo.getBrokerName());
        this.broker1.stop();
        Assert.assertTrue((String)"Timed out waiting for Backups to connect.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.debug("Current Backup Count = " + FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups());
                return FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups() == 1;
            }
        }));
        Assert.assertTrue((String)"Incorrect number of Transport interruptions", (this.transportInterruptions >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect number of Transport resumptions", (this.transportResumptions >= 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"conected to..", (Object)"2", (Object)this.currentBrokerInfo.getBrokerName());
        this.broker2.stop();
        Assert.assertTrue((String)"Timed out waiting for Backups to connect.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.debug("Current Backup Count = " + FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups());
                return FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups() == 0;
            }
        }));
        Assert.assertTrue((String)"Incorrect number of Transport interruptions", (this.transportInterruptions >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Incorrect number of Transport resumptions", (this.transportResumptions >= 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"conected to..", (Object)"3", (Object)this.currentBrokerInfo.getBrokerName());
    }

    @Test
    public void testBackupsRefilled() throws Exception {
        this.transport = this.createTransport(1);
        Assert.assertNotNull((Object)this.failoverTransport);
        Assert.assertTrue((boolean)this.failoverTransport.isBackup());
        Assert.assertEquals((long)1L, (long)this.failoverTransport.getBackupPoolSize());
        Assert.assertTrue((String)"Timed out waiting for Backups to connect.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.debug("Current Backup Count = " + FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups());
                return FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups() == 1;
            }
        }));
        this.broker1.stop();
        Assert.assertTrue((String)"Timed out waiting for Backups to connect.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.debug("Current Backup Count = " + FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups());
                return FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups() == 1;
            }
        }));
        this.broker2.stop();
        Assert.assertTrue((String)"Timed out waiting for Backups to connect.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.debug("Current Backup Count = " + FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups());
                return FailoverTransportBackupsTest.this.failoverTransport.getCurrentBackups() == 0;
            }
        }));
    }

    private BrokerService createBroker(String name) throws Exception {
        BrokerService bs = new BrokerService();
        bs.setBrokerName(name);
        bs.setUseJmx(false);
        bs.setPersistent(false);
        bs.addConnector("tcp://localhost:0");
        return bs;
    }

    protected Transport createTransport(int backups) throws Exception {
        String connectionUri = "failover://(" + ((TransportConnector)this.broker1.getTransportConnectors().get(0)).getPublishableConnectString() + "," + ((TransportConnector)this.broker2.getTransportConnectors().get(0)).getPublishableConnectString() + "," + ((TransportConnector)this.broker3.getTransportConnectors().get(0)).getPublishableConnectString() + ")";
        if (backups > 0) {
            connectionUri = connectionUri + "?randomize=false&backup=true&backupPoolSize=" + backups;
        }
        Transport transport = TransportFactory.connect((URI)new URI(connectionUri));
        transport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
                LOG.debug("Test Transport Listener received Command: " + command);
                if (command instanceof BrokerInfo) {
                    FailoverTransportBackupsTest.this.currentBrokerInfo = (BrokerInfo)command;
                    LOG.info("BrokerInfo: " + FailoverTransportBackupsTest.this.currentBrokerInfo);
                }
            }

            public void onException(IOException error) {
                LOG.debug("Test Transport Listener received Exception: " + error);
            }

            public void transportInterupted() {
                FailoverTransportBackupsTest.this.transportInterruptions++;
                LOG.debug("Test Transport Listener records transport Interrupted: " + FailoverTransportBackupsTest.this.transportInterruptions);
            }

            public void transportResumed() {
                FailoverTransportBackupsTest.this.transportResumptions++;
                LOG.debug("Test Transport Listener records transport Resumed: " + FailoverTransportBackupsTest.this.transportResumptions);
            }
        });
        transport.start();
        this.failoverTransport = (FailoverTransport)transport.narrow(FailoverTransport.class);
        return transport;
    }
}

