/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.NetworkTestSupport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverTransportBrokerTest
extends NetworkTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverTransportBrokerTest.class);
    public ActiveMQDestination destination;
    public int deliveryMode;

    public void initCombosForTestPublisherFailsOver() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destination", new Object[]{new ActiveMQQueue("TEST"), new ActiveMQTopic("TEST")});
    }

    public void testPublisherFailsOver() throws Exception {
        TransportConnector serverA;
        StubConnection connectionB;
        StubConnection connectionA;
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.request((Command)consumerInfo1);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        connection2.request((Command)consumerInfo2);
        LOG.info("Starting the failover connection.");
        StubConnection connection3 = this.createFailoverConnection(null);
        ConnectionInfo connectionInfo3 = this.createConnectionInfo();
        SessionInfo sessionInfo3 = this.createSessionInfo(connectionInfo3);
        ProducerInfo producerInfo3 = this.createProducerInfo(sessionInfo3);
        connection3.send((Command)connectionInfo3);
        connection3.send((Command)sessionInfo3);
        connection3.send((Command)producerInfo3);
        connection3.request((Command)this.createMessage(producerInfo3, this.destination, this.deliveryMode));
        FailoverTransport ft = (FailoverTransport)connection3.getTransport().narrow(FailoverTransport.class);
        if (this.connector.getServer().getConnectURI().equals(ft.getConnectedTransportURI())) {
            connectionA = connection1;
            connectionB = connection2;
            serverA = this.connector;
        } else {
            connectionA = connection2;
            connectionB = connection1;
            serverA = this.remoteConnector;
        }
        FailoverTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connectionA));
        this.assertNoMessagesLeft(connectionB);
        LOG.info("Disconnecting the active connection");
        serverA.stop();
        connection3.request((Command)this.createMessage(producerInfo3, this.destination, this.deliveryMode));
        FailoverTransportBrokerTest.assertNotNull((Object)this.receiveMessage(connectionB));
        this.assertNoMessagesLeft(connectionA);
    }

    public void testNoBrokersInBrokerInfo() throws Exception {
        final BrokerInfo[] info = new BrokerInfo[1];
        TransportListener listener = new TransportListener(){

            public void onCommand(Object command) {
                LOG.info("Got command: " + command);
                if (command instanceof BrokerInfo) {
                    info[0] = (BrokerInfo)command;
                }
            }

            public void onException(IOException error) {
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        };
        StubConnection c = this.createFailoverConnection(listener);
        int count = 0;
        while (count++ < 20 && info[0] == null) {
            TimeUnit.SECONDS.sleep(1L);
        }
        FailoverTransportBrokerTest.assertNotNull((String)"got a valid brokerInfo after 20 secs", (Object)info[0]);
        FailoverTransportBrokerTest.assertNull((String)"no peer brokers present", (Object)info[0].getPeerBrokerInfos());
    }

    @Override
    protected String getLocalURI() {
        return "tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true";
    }

    @Override
    protected String getRemoteURI() {
        return "tcp://localhost:0?wireFormat.tcpNoDelayEnabled=true";
    }

    protected StubConnection createFailoverConnection(TransportListener listener) throws Exception {
        URI failoverURI = new URI("failover://" + this.connector.getServer().getConnectURI() + "," + this.remoteConnector.getServer().getConnectURI() + "");
        Transport transport = TransportFactory.connect((URI)failoverURI);
        StubConnection connection = new StubConnection(transport, listener);
        this.connections.add(connection);
        return connection;
    }

    public static Test suite() {
        return FailoverTransportBrokerTest.suite(FailoverTransportBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FailoverTransportBrokerTest.suite());
    }
}

