/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ConfigurationException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;

public class StoreUsageLimitsTest {
    final int WAIT_TIME_MILLS = 20000;
    private static final String limitsLogLevel = "warn";
    final String toMatch = new String(Long.toString(0x7FFFFFFFFFFL));

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.getSystemUsage().getMemoryUsage().setLimit(Long.MAX_VALUE);
        broker.getSystemUsage().setCheckLimitsLogLevel(limitsLogLevel);
        broker.deleteAllMessages();
        return broker;
    }

    @Test
    public void testCheckLimitsLogLevel() throws Exception {
        final CountDownLatch foundMessage = new CountDownLatch(1);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                String message = (String)event.getMessage();
                if (message.contains(StoreUsageLimitsTest.this.toMatch) && event.getLevel().equals((Object)Level.WARN)) {
                    foundMessage.countDown();
                }
            }
        };
        Logger.getRootLogger().addAppender((Appender)appender);
        BrokerService brokerService = this.createBroker();
        brokerService.start();
        brokerService.stop();
        Assert.assertTrue((String)"Fount log message", (boolean)foundMessage.await(20000L, TimeUnit.MILLISECONDS));
        Logger.getRootLogger().removeAppender((Appender)appender);
    }

    @Test
    public void testCheckLimitsFailStart() throws Exception {
        final CountDownLatch foundMessage = new CountDownLatch(1);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                String message = (String)event.getMessage();
                if (message.contains(StoreUsageLimitsTest.this.toMatch) && event.getLevel().equals((Object)Level.ERROR)) {
                    foundMessage.countDown();
                }
            }
        };
        Logger.getRootLogger().addAppender((Appender)appender);
        BrokerService brokerService = this.createBroker();
        brokerService.setAdjustUsageLimits(false);
        try {
            brokerService.start();
            Assert.fail((String)"expect ConfigurationException");
        }
        catch (ConfigurationException expected) {
            Assert.assertTrue((String)"exception message match", (boolean)expected.getLocalizedMessage().contains(this.toMatch));
        }
        brokerService.stop();
        Assert.assertTrue((String)"Fount log message", (boolean)foundMessage.await(20000L, TimeUnit.MILLISECONDS));
        Logger.getRootLogger().removeAppender((Appender)appender);
    }
}

