/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.net.URI;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.MessageIdList;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoBrokerDurableForwardStaticRestartTest
extends JmsMultipleBrokersTestSupport {
    protected static final Logger LOG = LoggerFactory.getLogger(TwoBrokerDurableForwardStaticRestartTest.class);
    final ActiveMQTopic dest = new ActiveMQTopic("TEST.FOO");

    public void testNonDurableReceiveThrougRestart() throws Exception {
        this.bridgeBrokerPair("BrokerA", "BrokerB");
        this.bridgeBrokerPair("BrokerB", "BrokerC");
        this.registerDurableForwardSub("BrokerA", this.dest, "BrokerB");
        this.registerDurableForwardSub("BrokerB", this.dest, "BrokerC");
        this.startAllBrokers();
        this.waitForBridgeFormation();
        MessageConsumer clientC = this.createConsumer("BrokerC", (Destination)this.dest);
        this.sendMessages("BrokerA", (Destination)this.dest, 100);
        final MessageIdList messagesFromC = this.getConsumerMessages("BrokerC", clientC);
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return messagesFromC.getMessageCount() == 100;
            }
        });
        LOG.info("B got: " + messagesFromC.getMessageCount());
        TwoBrokerDurableForwardStaticRestartTest.assertEquals((int)100, (int)messagesFromC.getMessageCount());
        this.destroyBroker("BrokerB");
        this.sendMessages("BrokerA", (Destination)this.dest, 100);
        BrokerService broker = this.createBroker(new URI("broker:(tcp://0.0.0.0:61616)/BrokerB"));
        this.bridgeBrokerPair("BrokerB", "BrokerC");
        broker.start();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return messagesFromC.getMessageCount() == 200;
            }
        });
        LOG.info("B got: " + messagesFromC.getMessageCount());
        TwoBrokerDurableForwardStaticRestartTest.assertEquals((int)200, (int)messagesFromC.getMessageCount());
    }

    @Override
    protected void configureBroker(BrokerService broker) {
        broker.getManagementContext().setCreateConnector(false);
        broker.setAdvisorySupport(false);
    }

    private void registerDurableForwardSub(String brokerName, ActiveMQTopic dest, String remoteBrokerName) throws Exception {
        String clientId = "NC_" + remoteBrokerName + "_inbound_" + brokerName;
        String subName = "NC-DS_" + brokerName + "_" + dest.getPhysicalName();
        JmsMultipleBrokersTestSupport.BrokerItem brokerItem = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get(brokerName);
        Connection c = brokerItem.factory.createConnection();
        c.setClientID(clientId);
        Session session = c.createSession(false, 1);
        TopicSubscriber topicSubscriber = session.createDurableSubscriber((Topic)dest, subName);
        topicSubscriber.close();
        c.close();
    }

    protected NetworkConnector bridgeBrokerPair(String localBrokerName, String remoteBrokerName) throws Exception {
        BrokerService localBroker = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)localBrokerName)).broker;
        BrokerService remoteBroker = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)remoteBrokerName)).broker;
        List transportConnectors = remoteBroker.getTransportConnectors();
        if (!transportConnectors.isEmpty()) {
            URI remoteURI = ((TransportConnector)transportConnectors.get(0)).getConnectUri();
            String uri = "static:(" + remoteURI + ")";
            DiscoveryNetworkConnector connector = new DiscoveryNetworkConnector(new URI(uri));
            connector.setDynamicOnly(false);
            connector.setMessageTTL(2);
            connector.setStaticBridge(true);
            localBroker.addNetworkConnector((NetworkConnector)connector);
            return connector;
        }
        throw new Exception("Remote broker has no registered connectors.");
    }

    @Override
    public void setUp() throws Exception {
        File dataDir = new File(IOHelper.getDefaultDataDirectory());
        LOG.info("Delete dataDir.." + dataDir.getCanonicalPath());
        TestSupport.recursiveDelete(dataDir);
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://0.0.0.0:0)/BrokerA"));
        this.createBroker(new URI("broker:(tcp://0.0.0.0:61616)/BrokerB"));
        this.createBroker(new URI("broker:(tcp://0.0.0.0:0)/BrokerC"));
    }
}

