/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3675Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ3675Test.class);
    private static final int deliveryMode = 1;
    private static final ActiveMQTopic destination = new ActiveMQTopic("XYZ");
    private ActiveMQConnectionFactory factory;
    private BrokerService broker;

    public TopicViewMBean getTopicView() throws Exception {
        ObjectName destinationName = this.broker.getAdminView().getTopics()[0];
        TopicViewMBean topicView = (TopicViewMBean)this.broker.getManagementContext().newProxyInstance(destinationName, TopicViewMBean.class, true);
        return topicView;
    }

    @Test
    public void countConsumers() throws Exception {
        Connection producerConnection = this.factory.createConnection();
        producerConnection.start();
        Connection consumerConnection = this.factory.createConnection();
        consumerConnection.setClientID("subscriber1");
        Session consumerMQSession = consumerConnection.createSession(false, 2);
        TopicSubscriber consumer = consumerMQSession.createDurableSubscriber((Topic)destination, "myTopic");
        consumerConnection.start();
        Session session = producerConnection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(1);
        final BrokerView brokerView = this.broker.getAdminView();
        final TopicViewMBean topicView = this.getTopicView();
        Assert.assertTrue((String)"Should have one consumer on topic: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return topicView.getConsumerCount() == 1L;
            }
        }));
        consumer.close();
        Assert.assertTrue((String)"Durable consumer should now be inactive.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return brokerView.getInactiveDurableTopicSubscribers().length == 1;
            }
        }));
        try {
            brokerView.removeTopic(destination.getTopicName());
        }
        catch (Exception e1) {
            Assert.fail((String)("Unable to remove destination:" + destination.getPhysicalName()));
        }
        Assert.assertTrue((String)"Should have no topics on the broker", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return brokerView.getTopics().length == 0;
            }
        }));
        try {
            brokerView.destroyDurableSubscriber("subscriber1", "myTopic");
        }
        catch (Exception e) {
            Assert.fail((String)"Exception not expected when attempting to delete Durable consumer.");
        }
        Assert.assertTrue((String)"Should be no durable consumers active or inactive.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return brokerView.getInactiveDurableTopicSubscribers().length == 0 && brokerView.getDurableTopicSubscribers().length == 0;
            }
        }));
        consumer = consumerMQSession.createDurableSubscriber((Topic)destination, "myTopic");
        consumer.close();
        Assert.assertTrue((String)"Should be one consumer on the Topic.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("Number of inactive consumers: " + brokerView.getInactiveDurableTopicSubscribers().length);
                return brokerView.getInactiveDurableTopicSubscribers().length == 1;
            }
        }));
        final TopicViewMBean recreatedTopicView = this.getTopicView();
        Assert.assertTrue((String)"Should have one consumer on topic: ", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return recreatedTopicView.getConsumerCount() == 1L;
            }
        }));
    }

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        TransportConnector connector = this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(connector.getPublishableConnectString());
        this.factory.setAlwaysSyncSend(true);
        this.factory.setDispatchAsync(false);
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }
}

