/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.DataFormatException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.junit.EmbeddedActiveMQBroker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class AMQ6244Test {
    public static final byte[] ORIG_MSG_CONTENT = AMQ6244Test.randomByteArray();
    @Rule
    public TestName name = new TestName();
    @Rule
    public EmbeddedActiveMQBroker brokerRule = new EmbeddedActiveMQBroker();

    public AMQ6244Test() {
        this.brokerRule.setBrokerName(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void bytesMsgCompressedFlagTest() throws Exception {
        block7: {
            ActiveMQConnection compressionEnabledConnection = AMQ6244Test.createConnection(this.brokerRule.getVmURL(), true);
            ActiveMQConnection compressionDisabledConnection = AMQ6244Test.createConnection(this.brokerRule.getVmURL(), false);
            Session consumerSession = compressionDisabledConnection.createSession(false, 1);
            Queue destination = consumerSession.createQueue(this.name.getMethodName());
            MessageConsumer consumer = consumerSession.createConsumer((Destination)destination);
            Session compressionDisabledProducerSession = compressionDisabledConnection.createSession(false, 1);
            MessageProducer compressionDisabledProducer = compressionDisabledProducerSession.createProducer((Destination)destination);
            Session compressionEnabledProducerSession = compressionEnabledConnection.createSession(false, 1);
            MessageProducer compressionEnabledProducer = compressionEnabledProducerSession.createProducer((Destination)destination);
            try {
                ActiveMQBytesMessage originalCompressedMsg = (ActiveMQBytesMessage)compressionEnabledProducerSession.createBytesMessage();
                originalCompressedMsg.writeBytes(ORIG_MSG_CONTENT);
                Assert.assertFalse((boolean)originalCompressedMsg.isReadOnlyBody());
                compressionEnabledProducer.send((Message)originalCompressedMsg);
                Assert.assertEquals((String)"Once sent, the Message's 'compressed' flag should match the 'useCompression' flag on the Producer's Connection", (Object)compressionEnabledConnection.isUseCompression(), (Object)originalCompressedMsg.isCompressed());
                ActiveMQBytesMessage compressedMsg = this.receiveMsg(consumer, (ActiveMQMessage)originalCompressedMsg);
                this.validateMsgContent(compressedMsg);
                AMQ6244Test.makeWritable((ActiveMQMessage)compressedMsg);
                compressedMsg.setStringProperty(this.getClass().getName(), "test");
                compressionDisabledProducer.send((Message)compressedMsg);
                Assert.assertEquals((String)"AMQ-6244 Error State Achieved: Produced Message's 'compressed' flag is enabled after message is published on a connection with 'useCompression=false'", (Object)compressionDisabledConnection.isUseCompression(), (Object)compressedMsg.isCompressed());
                try {
                    ActiveMQBytesMessage uncompressedMsg = this.receiveMsg(consumer, (ActiveMQMessage)compressedMsg);
                    this.validateMsgContent(uncompressedMsg);
                }
                catch (JMSException jmsE) {
                    Throwable rootCause = null;
                    for (Throwable cause = jmsE.getCause(); cause != null; cause = cause.getCause()) {
                        rootCause = cause;
                    }
                    if (rootCause instanceof DataFormatException || rootCause instanceof NegativeArraySizeException) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        jmsE.printStackTrace(pw);
                        Assert.fail((String)("AMQ-6244 Error State Achieved: Attempted to decompress BytesMessage contents that are not compressed\n" + sw.toString()));
                        break block7;
                    }
                    throw jmsE;
                }
            }
            finally {
                compressionEnabledProducerSession.close();
                compressionEnabledConnection.close();
                consumerSession.close();
                compressionDisabledProducerSession.close();
                compressionDisabledConnection.close();
            }
        }
    }

    private ActiveMQBytesMessage receiveMsg(MessageConsumer consumer, ActiveMQMessage sentMessage) throws JMSException {
        ActiveMQBytesMessage message = (ActiveMQBytesMessage)consumer.receive();
        Assert.assertNotNull((Object)message);
        Assert.assertTrue((String)"Consumed Message should be read-only", (boolean)message.isReadOnlyBody());
        Assert.assertEquals((String)"Consumed Message's 'compressed' flag should match the produced Message's 'compressed' flag", (Object)sentMessage.isCompressed(), (Object)message.isCompressed());
        return message;
    }

    private void validateMsgContent(ActiveMQBytesMessage message) throws JMSException {
        byte[] msgContent = new byte[(int)message.getBodyLength()];
        message.readBytes(msgContent);
        Assert.assertTrue((String)"Consumed Message content should match the original Message content", (boolean)Arrays.equals(ORIG_MSG_CONTENT, msgContent));
    }

    protected static ActiveMQConnection createConnection(String URL2, boolean useCompression) throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(URL2);
        factory.setUseCompression(useCompression);
        Connection connection = factory.createConnection();
        connection.start();
        return (ActiveMQConnection)connection;
    }

    protected static byte[] randomByteArray() {
        Random random = new Random();
        byte[] byteArray = new byte[random.nextInt(10240)];
        random.nextBytes(byteArray);
        return byteArray;
    }

    protected static void makeWritable(ActiveMQMessage message) {
        message.setReadOnlyBody(false);
        message.setReadOnlyProperties(false);
    }
}

