/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.demo;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleQueueReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleQueueReceiver.class);

    private SimpleQueueReceiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String queueName = null;
        InitialContext jndiContext = null;
        QueueConnectionFactory queueConnectionFactory = null;
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        Queue queue = null;
        QueueReceiver queueReceiver = null;
        TextMessage message = null;
        if (args.length != 1) {
            LOG.info("Usage: java SimpleQueueReceiver <queue-name>");
            System.exit(1);
        }
        queueName = args[0];
        LOG.info("Queue name is " + queueName);
        try {
            jndiContext = new InitialContext();
        }
        catch (NamingException e) {
            LOG.info("Could not create JNDI API context: " + e.toString());
            System.exit(1);
        }
        try {
            queueConnectionFactory = (QueueConnectionFactory)jndiContext.lookup("QueueConnectionFactory");
            queue = (Queue)jndiContext.lookup(queueName);
        }
        catch (NamingException e) {
            LOG.info("JNDI API lookup failed: " + e.toString());
            System.exit(1);
        }
        try {
            queueConnection = queueConnectionFactory.createQueueConnection();
            queueSession = queueConnection.createQueueSession(false, 1);
            queueReceiver = queueSession.createReceiver(queue);
            queueConnection.start();
            while (true) {
                Message m;
                if ((m = queueReceiver.receive(1L)) == null) {
                    continue;
                }
                if (m instanceof TextMessage) {
                    message = (TextMessage)m;
                    LOG.info("Reading message: " + message.getText());
                    continue;
                }
                break;
            }
        }
        catch (JMSException e) {
            LOG.info("Exception occurred: " + e.toString());
        }
        finally {
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }
}

