/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.activemq.util.Wait;

public class DurableFiveBrokerNetworkBridgeTest
extends JmsMultipleBrokersTestSupport {
    private boolean duplex = true;
    private boolean deletePersistentMessagesOnStartup = true;

    @Override
    protected NetworkConnector bridgeBrokers(String localBrokerName, String remoteBrokerName) throws Exception {
        NetworkConnector connector = super.bridgeBrokers(localBrokerName, remoteBrokerName);
        ArrayList<ActiveMQTopic> includedDestinations = new ArrayList<ActiveMQTopic>();
        includedDestinations.add(new ActiveMQTopic("TEST.FOO?forceDurable=true"));
        connector.setDynamicallyIncludedDestinations(includedDestinations);
        connector.setDuplex(this.duplex);
        connector.setDecreaseNetworkConsumerPriority(false);
        connector.setConduitSubscriptions(true);
        connector.setSyncDurableSubs(true);
        connector.setNetworkTTL(-1);
        connector.setClientIdToken("|");
        return connector;
    }

    public void testDurablePropagationBrokerRestart() throws Exception {
        this.duplex = true;
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        this.bridgeBrokers("Broker_C_C", "Broker_D_D");
        this.bridgeBrokers("Broker_D_D", "Broker_E_E");
        this.startAllBrokers();
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        Connection conn = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).factory.createConnection();
        conn.setClientID("clientId1");
        conn.start();
        Session ses = conn.createSession(false, 1);
        TopicSubscriber clientA = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA");
        TopicSubscriber clientA2 = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA2");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        Connection conn2 = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).factory.createConnection();
        conn2.setClientID("clientId2");
        conn2.start();
        Session ses2 = conn2.createSession(false, 1);
        TopicSubscriber clientE = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subE");
        TopicSubscriber clientE2 = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subE2");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        clientA.close();
        clientA2.close();
        clientE.close();
        clientE2.close();
        this.destroyAllBrokers();
        this.deletePersistentMessagesOnStartup = false;
        String options = new String("?persistent=true&useJmx=false");
        this.createBroker(new URI("broker:(tcp://localhost:61616)/Broker_A_A" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/Broker_B_B" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61618)/Broker_C_C" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61619)/Broker_D_D" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61620)/Broker_E_E" + options));
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        this.bridgeBrokers("Broker_C_C", "Broker_D_D");
        this.bridgeBrokers("Broker_D_D", "Broker_E_E");
        this.startAllBrokers();
        conn = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).factory.createConnection();
        conn.setClientID("clientId1");
        conn.start();
        ses = conn.createSession(false, 1);
        conn2 = ((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).factory.createConnection();
        conn2.setClientID("clientId2");
        conn2.start();
        ses2 = conn2.createSession(false, 1);
        clientE = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subE");
        clientE.close();
        ses.unsubscribe("subA");
        ses.unsubscribe("subA2");
        ses2.unsubscribe("subE");
        ses2.unsubscribe("subE2");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).broker, dest, 0);
    }

    public void testDurablePropagationDuplex() throws Exception {
        this.duplex = true;
        this.testDurablePropagation();
    }

    public void testDurablePropagationOneWay() throws Exception {
        this.duplex = false;
        this.testDurablePropagation();
    }

    protected void testDurablePropagation() throws Exception {
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        if (!this.duplex) {
            this.bridgeBrokers("Broker_B_B", "Broker_A_A");
            this.bridgeBrokers("Broker_C_C", "Broker_B_B");
        }
        this.startAllBrokers();
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        Session ses = this.createSession("Broker_A_A");
        TopicSubscriber clientA = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA");
        TopicSubscriber clientB = ses.createDurableSubscriber((javax.jms.Topic)dest, "subB");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.sendMessages("Broker_C_C", (Destination)dest, 1);
        DurableFiveBrokerNetworkBridgeTest.assertNotNull((Object)clientA.receive(1000L));
        DurableFiveBrokerNetworkBridgeTest.assertNotNull((Object)clientB.receive(1000L));
        Session ses2 = this.createSession("Broker_C_C");
        TopicSubscriber clientC = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subC");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        clientA.close();
        clientB.close();
        clientC.close();
        ses.unsubscribe("subA");
        ses.unsubscribe("subB");
        ses2.unsubscribe("subC");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
    }

    public void testDurablePropagationConsumerAllBrokersDuplex() throws Exception {
        this.duplex = true;
        this.testDurablePropagationConsumerAllBrokers();
    }

    public void testDurablePropagationConsumerAllBrokersOneWay() throws Exception {
        this.duplex = false;
        this.testDurablePropagationConsumerAllBrokers();
    }

    protected void testDurablePropagationConsumerAllBrokers() throws Exception {
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        if (!this.duplex) {
            this.bridgeBrokers("Broker_B_B", "Broker_A_A");
            this.bridgeBrokers("Broker_C_C", "Broker_B_B");
        }
        this.startAllBrokers();
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        Session ses = this.createSession("Broker_A_A");
        TopicSubscriber clientA = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        Session ses2 = this.createSession("Broker_B_B");
        TopicSubscriber clientB = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subB");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        Session ses3 = this.createSession("Broker_C_C");
        TopicSubscriber clientC = ses3.createDurableSubscriber((javax.jms.Topic)dest, "subC");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        clientA.close();
        clientB.close();
        clientC.close();
        ses.unsubscribe("subA");
        ses2.unsubscribe("subB");
        ses3.unsubscribe("subC");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
    }

    public void testDurablePropagation5BrokerDuplex() throws Exception {
        this.duplex = true;
        this.testDurablePropagation5Broker();
    }

    public void testDurablePropagation5BrokerOneWay() throws Exception {
        this.duplex = false;
        this.testDurablePropagation5Broker();
    }

    protected void testDurablePropagation5Broker() throws Exception {
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        this.bridgeBrokers("Broker_C_C", "Broker_D_D");
        this.bridgeBrokers("Broker_D_D", "Broker_E_E");
        if (!this.duplex) {
            this.bridgeBrokers("Broker_B_B", "Broker_A_A");
            this.bridgeBrokers("Broker_C_C", "Broker_B_B");
            this.bridgeBrokers("Broker_D_D", "Broker_C_C");
            this.bridgeBrokers("Broker_E_E", "Broker_D_D");
        }
        this.startAllBrokers();
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        Session ses = this.createSession("Broker_A_A");
        TopicSubscriber clientA = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA");
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.sendMessages("Broker_E_E", (Destination)dest, 1);
        DurableFiveBrokerNetworkBridgeTest.assertNotNull((Object)clientA.receive(1000L));
        Session ses2 = this.createSession("Broker_E_E");
        TopicSubscriber clientE = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subE");
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        clientA.close();
        clientE.close();
        ses.unsubscribe("subA");
        ses2.unsubscribe("subE");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_E_E")).broker, dest, 0);
    }

    public void testDurablePropagationSpokeDuplex() throws Exception {
        this.duplex = true;
        this.testDurablePropagationSpoke();
    }

    public void testDurablePropagationSpokeOneWay() throws Exception {
        this.duplex = false;
        this.testDurablePropagationSpoke();
    }

    protected void testDurablePropagationSpoke() throws Exception {
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        this.bridgeBrokers("Broker_B_B", "Broker_D_D");
        if (!this.duplex) {
            this.bridgeBrokers("Broker_B_B", "Broker_A_A");
            this.bridgeBrokers("Broker_C_C", "Broker_B_B");
            this.bridgeBrokers("Broker_D_D", "Broker_B_B");
        }
        this.startAllBrokers();
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        Session ses = this.createSession("Broker_A_A");
        Session ses2 = this.createSession("Broker_B_B");
        Session ses3 = this.createSession("Broker_C_C");
        Session ses4 = this.createSession("Broker_D_D");
        TopicSubscriber clientA = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA");
        TopicSubscriber clientAB = ses.createDurableSubscriber((javax.jms.Topic)dest, "subAB");
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        TopicSubscriber clientD = ses4.createDurableSubscriber((javax.jms.Topic)dest, "subD");
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        this.sendMessages("Broker_A_A", (Destination)dest, 1);
        DurableFiveBrokerNetworkBridgeTest.assertNotNull((Object)clientD.receive(1000L));
        this.sendMessages("Broker_C_C", (Destination)dest, 1);
        DurableFiveBrokerNetworkBridgeTest.assertNotNull((Object)clientD.receive(1000L));
        TopicSubscriber clientB = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subB");
        TopicSubscriber clientC = ses3.createDurableSubscriber((javax.jms.Topic)dest, "subC");
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 3);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        clientA.close();
        clientAB.close();
        clientB.close();
        clientC.close();
        clientD.close();
        ses.unsubscribe("subA");
        ses.unsubscribe("subAB");
        ses2.unsubscribe("subB");
        ses3.unsubscribe("subC");
        ses4.unsubscribe("subD");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_D_D")).broker, dest, 0);
    }

    public void testForceDurablePropagationDuplex() throws Exception {
        this.duplex = true;
        this.testForceDurablePropagation();
    }

    public void testForceDurablePropagationOneWay() throws Exception {
        this.duplex = false;
        this.testForceDurablePropagation();
    }

    protected void testForceDurablePropagation() throws Exception {
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        if (!this.duplex) {
            this.bridgeBrokers("Broker_B_B", "Broker_A_A");
            this.bridgeBrokers("Broker_C_C", "Broker_B_B");
        }
        this.startAllBrokers();
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        Session ses = this.createSession("Broker_A_A");
        MessageConsumer clientA = ses.createConsumer((Destination)dest);
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.sendMessages("Broker_C_C", (Destination)dest, 1);
        DurableFiveBrokerNetworkBridgeTest.assertNotNull((Object)clientA.receive(1000L));
        Session ses2 = this.createSession("Broker_C_C");
        MessageConsumer clientC = ses2.createConsumer((Destination)dest);
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        clientA.close();
        clientC.close();
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
    }

    public void testDurablePropagationSyncDuplex() throws Exception {
        this.duplex = true;
        this.testDurablePropagationSync();
    }

    public void testDurablePropagationSyncOneWay() throws Exception {
        this.duplex = false;
        this.testDurablePropagationSync();
    }

    protected void testDurablePropagationSync() throws Exception {
        NetworkConnector nc1 = this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        NetworkConnector nc2 = this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        NetworkConnector nc3 = null;
        NetworkConnector nc4 = null;
        if (!this.duplex) {
            nc3 = this.bridgeBrokers("Broker_B_B", "Broker_A_A");
            nc4 = this.bridgeBrokers("Broker_C_C", "Broker_B_B");
        }
        this.startAllBrokers();
        nc1.stop();
        nc2.stop();
        if (!this.duplex) {
            nc3.stop();
            nc4.stop();
        }
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        Session ses = this.createSession("Broker_A_A");
        Session ses2 = this.createSession("Broker_C_C");
        TopicSubscriber clientA = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA");
        TopicSubscriber clientB = ses.createDurableSubscriber((javax.jms.Topic)dest, "subB");
        TopicSubscriber clientC = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subC");
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
        nc1.start();
        nc2.start();
        if (!this.duplex) {
            nc3.start();
            nc4.start();
        }
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        clientA.close();
        clientB.close();
        clientC.close();
    }

    public void testDurablePropagationMultipleBridgesDifferentDestinations() throws Exception {
        this.duplex = true;
        this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        NetworkConnector nc3 = this.bridgeBrokers("Broker_A_A", "Broker_B_B");
        NetworkConnector nc4 = this.bridgeBrokers("Broker_B_B", "Broker_C_C");
        nc3.setName("nc_3_3");
        nc4.setName("nc_4_4");
        ArrayList<ActiveMQTopic> includedDestinations = new ArrayList<ActiveMQTopic>();
        includedDestinations.add(new ActiveMQTopic("TEST.FOO2?forceDurable=true"));
        nc3.setDynamicallyIncludedDestinations(includedDestinations);
        nc4.setDynamicallyIncludedDestinations(includedDestinations);
        this.startAllBrokers();
        ActiveMQTopic dest = (ActiveMQTopic)this.createDestination("TEST.FOO", true);
        ActiveMQTopic dest2 = (ActiveMQTopic)this.createDestination("TEST.FOO2", true);
        Session ses = this.createSession("Broker_A_A");
        Session ses2 = this.createSession("Broker_C_C");
        TopicSubscriber clientA = ses.createDurableSubscriber((javax.jms.Topic)dest, "subA");
        TopicSubscriber clientAa = ses.createDurableSubscriber((javax.jms.Topic)dest2, "subAa");
        TopicSubscriber clientC = ses2.createDurableSubscriber((javax.jms.Topic)dest, "subC");
        TopicSubscriber clientCc = ses2.createDurableSubscriber((javax.jms.Topic)dest2, "subCc");
        Thread.sleep(1000L);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest2, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest2, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest2, 1);
        clientA.close();
        clientC.close();
        ses.unsubscribe("subA");
        ses2.unsubscribe("subC");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest2, 2);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest2, 1);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest2, 1);
        clientAa.close();
        clientCc.close();
        ses.unsubscribe("subAa");
        ses2.unsubscribe("subCc");
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_B_B")).broker, dest2, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_C_C")).broker, dest2, 0);
        this.assertNCDurableSubsCount(((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get((Object)"Broker_A_A")).broker, dest2, 0);
    }

    protected void assertNCDurableSubsCount(final BrokerService brokerService, final ActiveMQTopic dest, final int count) throws Exception {
        DurableFiveBrokerNetworkBridgeTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return count == DurableFiveBrokerNetworkBridgeTest.this.getNCDurableSubs(brokerService, dest).size();
            }
        }, (long)10000L, (long)500L));
    }

    protected List<DurableTopicSubscription> getNCDurableSubs(BrokerService brokerService, ActiveMQTopic dest) throws Exception {
        ArrayList<DurableTopicSubscription> subs = new ArrayList<DurableTopicSubscription>();
        org.apache.activemq.broker.region.Destination d = brokerService.getDestination((ActiveMQDestination)dest);
        Topic destination = null;
        destination = d instanceof DestinationFilter ? (Topic)((DestinationFilter)d).getAdaptor(Topic.class) : (Topic)d;
        for (SubscriptionKey key : destination.getDurableTopicSubs().keySet()) {
            DurableTopicSubscription sub;
            if (!key.getSubscriptionName().startsWith("NC-DS_") || (sub = (DurableTopicSubscription)destination.getDurableTopicSubs().get(key)) == null) continue;
            subs.add(sub);
        }
        return subs;
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.deletePersistentMessagesOnStartup = true;
        String options = new String("?persistent=true&useJmx=false");
        this.createBroker(new URI("broker:(tcp://localhost:61616)/Broker_A_A" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/Broker_B_B" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61618)/Broker_C_C" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61619)/Broker_D_D" + options));
        this.createBroker(new URI("broker:(tcp://localhost:61620)/Broker_E_E" + options));
    }

    @Override
    protected void configureBroker(BrokerService broker) {
        broker.setBrokerId(broker.getBrokerName());
        broker.setDeleteAllMessagesOnStartup(this.deletePersistentMessagesOnStartup);
        broker.setDataDirectory("target" + File.separator + "test-data" + File.separator + "DurableFiveBrokerNetworkBridgeTest");
    }

    protected Session createSession(String broker) throws Exception {
        Connection con = this.createConnection(broker);
        con.start();
        return con.createSession(false, 1);
    }

    public static Test suite() {
        return DurableFiveBrokerNetworkBridgeTest.suite(DurableFiveBrokerNetworkBridgeTest.class);
    }
}

