/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;

public class BooleanStreamTest
extends TestCase {
    protected OpenWireFormat openWireformat;
    protected int endOfStreamMarker = 305419896;
    int numberOfBytes = 1600;

    public void testBooleanMarshallingUsingAllTrue() throws Exception {
        this.testBooleanStream(this.numberOfBytes, new BooleanValueSet(){

            @Override
            public boolean getBooleanValueFor(int index, int count) {
                return true;
            }
        });
    }

    public void testBooleanMarshallingUsingAllFalse() throws Exception {
        this.testBooleanStream(this.numberOfBytes, new BooleanValueSet(){

            @Override
            public boolean getBooleanValueFor(int index, int count) {
                return false;
            }
        });
    }

    public void testBooleanMarshallingUsingOddAlternateTrueFalse() throws Exception {
        this.testBooleanStream(this.numberOfBytes, new BooleanValueSet(){

            @Override
            public boolean getBooleanValueFor(int index, int count) {
                return (index & 1) == 0;
            }
        });
    }

    public void testBooleanMarshallingUsingEvenAlternateTrueFalse() throws Exception {
        this.testBooleanStream(this.numberOfBytes, new BooleanValueSet(){

            @Override
            public boolean getBooleanValueFor(int index, int count) {
                return (index & 1) != 0;
            }
        });
    }

    protected void testBooleanStream(int numberOfBytes, BooleanValueSet valueSet) throws Exception {
        for (int i = 0; i < numberOfBytes; ++i) {
            try {
                this.assertMarshalBooleans(i, valueSet);
                continue;
            }
            catch (Throwable e) {
                throw (AssertionFailedError)new AssertionFailedError("Iteration failed at: " + i).initCause(e);
            }
        }
    }

    protected void assertMarshalBooleans(int count, BooleanValueSet valueSet) throws Exception {
        BooleanStream bs = new BooleanStream();
        for (int i = 0; i < count; ++i) {
            bs.writeBoolean(valueSet.getBooleanValueFor(i, count));
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(buffer);
        bs.marshal((DataOutput)ds);
        ds.writeInt(this.endOfStreamMarker);
        ds.close();
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        bs = new BooleanStream();
        try {
            bs.unmarshal((DataInput)dis);
        }
        catch (Exception e) {
            e.printStackTrace();
            BooleanStreamTest.fail((String)("Failed to unmarshal: " + count + " booleans: " + e));
        }
        for (int i = 0; i < count; ++i) {
            boolean expected = valueSet.getBooleanValueFor(i, count);
            try {
                boolean actual = bs.readBoolean();
                BooleanStreamTest.assertEquals((String)("value of object: " + i + " was: " + actual), (boolean)expected, (boolean)actual);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                BooleanStreamTest.fail((String)("Failed to parse boolean: " + i + " out of: " + count + " due to: " + e));
            }
        }
        int marker = dis.readInt();
        BooleanStreamTest.assertEquals((String)("Marker int when unmarshalling: " + count + " booleans"), (String)Integer.toHexString(this.endOfStreamMarker), (String)Integer.toHexString(marker));
        try {
            dis.readByte();
            BooleanStreamTest.fail((String)"Should have reached the end of the stream");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.openWireformat = this.createOpenWireFormat();
    }

    protected OpenWireFormat createOpenWireFormat() {
        OpenWireFormat wf = new OpenWireFormat();
        wf.setCacheEnabled(true);
        wf.setStackTraceEnabled(false);
        wf.setVersion(1);
        return wf;
    }

    static interface BooleanValueSet {
        public boolean getBooleanValueFor(int var1, int var2);
    }
}

