/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.activemq.command.BrokerSubscriptionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerSubscriptionInfoTest {
    static final Logger LOG = LoggerFactory.getLogger(BrokerSubscriptionInfoTest.class);

    @Test
    public void testMarshalClientProperties() throws IOException {
        OpenWireFormatFactory factory = new OpenWireFormatFactory();
        factory.setCacheEnabled(true);
        OpenWireFormat wf = (OpenWireFormat)factory.createWireFormat();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(buffer);
        ConsumerInfo info = new ConsumerInfo();
        info.setClientId("clientId");
        info.setConsumerId(new ConsumerId());
        int size = 1000;
        ConsumerInfo[] infos = new ConsumerInfo[size];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = info;
        }
        BrokerSubscriptionInfo bsi = new BrokerSubscriptionInfo();
        bsi.setSubscriptionInfos(infos);
        wf.marshal((Object)bsi, (DataOutput)ds);
        ds.close();
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        BrokerSubscriptionInfo actual = (BrokerSubscriptionInfo)wf.unmarshal((DataInput)dis);
        Assert.assertEquals((long)size, (long)actual.getSubscriptionInfos().length);
    }
}

