/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQMessageAudit;
import org.apache.activemq.perf.PerfRate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfConsumer
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(PerfConsumer.class);
    protected Connection connection;
    protected MessageConsumer consumer;
    protected long sleepDuration;
    protected long initialDelay;
    protected boolean enableAudit = false;
    protected ActiveMQMessageAudit audit = new ActiveMQMessageAudit(16384, 20);
    protected boolean firstMessage = true;
    protected String lastMsgId;
    protected PerfRate rate = new PerfRate();

    public PerfConsumer(ConnectionFactory fac, Destination dest, String consumerName) throws JMSException {
        this.connection = fac.createConnection();
        this.connection.setClientID(consumerName);
        Session s = this.connection.createSession(false, 1);
        this.consumer = dest instanceof Topic && consumerName != null && consumerName.length() > 0 ? s.createDurableSubscriber((Topic)dest, consumerName) : s.createConsumer(dest);
        this.consumer.setMessageListener((MessageListener)this);
    }

    public PerfConsumer(ConnectionFactory fac, Destination dest) throws JMSException {
        this(fac, dest, null);
    }

    public void start() throws JMSException {
        this.connection.start();
        this.rate.reset();
    }

    public void stop() throws JMSException {
        this.connection.stop();
    }

    public void shutDown() throws JMSException {
        this.connection.close();
    }

    public PerfRate getRate() {
        return this.rate;
    }

    public void onMessage(Message msg) {
        if (this.firstMessage) {
            this.firstMessage = false;
            if (this.getInitialDelay() > 0L) {
                try {
                    Thread.sleep(this.getInitialDelay());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.rate.increment();
        try {
            if (this.enableAudit && !this.audit.isInOrder(msg.getJMSMessageID())) {
                LOG.error("Message out of order!!" + msg.getJMSMessageID() + " LAST = " + this.lastMsgId);
            }
            if (this.enableAudit && this.audit.isDuplicate(msg)) {
                LOG.error("Duplicate Message!" + msg);
            }
            this.lastMsgId = msg.getJMSMessageID();
        }
        catch (JMSException e1) {
            e1.printStackTrace();
        }
        try {
            if (this.sleepDuration != 0L) {
                Thread.sleep(this.sleepDuration);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized long getSleepDuration() {
        return this.sleepDuration;
    }

    public synchronized void setSleepDuration(long sleepDuration) {
        this.sleepDuration = sleepDuration;
    }

    public boolean isEnableAudit() {
        return this.enableAudit;
    }

    public void setEnableAudit(boolean doAudit) {
        this.enableAudit = doAudit;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }
}

