/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.auto;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.transport.TransportBrokerTestSupport;

public class AutoNIOSslTransportBrokerTest
extends TransportBrokerTestSupport {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";

    @Override
    protected String getBindLocation() {
        return "auto+nio+ssl://localhost:0?transport.soWriteTimeout=20000";
    }

    @Override
    protected URI getBindURI() throws URISyntaxException {
        return new URI("auto+nio+ssl://localhost:0?soWriteTimeout=20000");
    }

    @Override
    protected void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        this.maxWait = 10000;
        super.setUp();
    }

    public static Test suite() {
        return AutoNIOSslTransportBrokerTest.suite(AutoNIOSslTransportBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AutoNIOSslTransportBrokerTest.suite());
    }
}

