/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.auto;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AutoTransportConnectionsTest {
    @Rule
    public Timeout globalTimeout = new Timeout(60L, TimeUnit.SECONDS);
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private static final int maxConnections = 20;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private String connectionUri;
    private BrokerService service;
    private TransportConnector connector;
    private final String transportType;

    @Parameterized.Parameters(name="transport={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"auto"}, {"auto+nio"}, {"auto+ssl"}, {"auto+nio+ssl"});
    }

    public AutoTransportConnectionsTest(String transportType) {
        this.transportType = transportType;
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        this.service = new BrokerService();
        this.service.setPersistent(false);
        this.service.setUseJmx(false);
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        this.service.stop();
        this.service.waitUntilStopped();
    }

    public void configureConnectorAndStart(String bindAddress) throws Exception {
        this.connector = this.service.addConnector(bindAddress);
        this.connectionUri = this.connector.getPublishableConnectString();
        if (this.connectionUri.contains("ssl")) {
            this.connectionUri = this.connectionUri + (this.connectionUri.contains("?") ? "&socket.verifyHostName=false" : "?socket.verifyHostName=false");
        }
        this.service.start();
        this.service.waitUntilStarted();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    @Test
    public void testMaxConnectionControl() throws Exception {
        this.configureConnectorAndStart(this.transportType + "://0.0.0.0:0?maxConnectionThreadPoolSize=10&maximumConnections=20");
        final ConnectionFactory cf = this.createConnectionFactory();
        final CountDownLatch startupLatch = new CountDownLatch(1);
        int i = 0;
        while (i < 30) {
            final int count = i++;
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    Connection conn = null;
                    try {
                        startupLatch.await();
                        Thread.sleep(count * 3);
                        conn = cf.createConnection();
                        conn.start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        TcpTransportServer transportServer = (TcpTransportServer)this.connector.getServer();
        Assert.assertEquals((long)20L, (long)transportServer.getMaximumConnections());
        Assert.assertEquals((long)0L, (long)this.connector.getConnections().size());
        startupLatch.countDown();
        final TransportConnector connector = this.connector;
        Assert.assertTrue((String)("Expected: 20 found: " + connector.getConnections().size()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return connector.getConnections().size() == 20;
            }
        }));
    }

    @Test
    public void testConcurrentConnections() throws Exception {
        this.configureConnectorAndStart(this.transportType + "://0.0.0.0:0");
        final int connectionAttempts = 50;
        final ConnectionFactory factory = this.createConnectionFactory();
        final AtomicInteger connectedCount = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            for (int i = 0; i < connectionAttempts; ++i) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            latch.await();
                            Connection con = factory.createConnection();
                            con.start();
                            connectedCount.incrementAndGet();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            latch.countDown();
            Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return connectedCount.get() == connectionAttempts;
                }
            }));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

