/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.MessageIdList;

public class StaticNetworkTest
extends JmsMultipleBrokersTestSupport {
    public void testStaticNetwork() throws Exception {
        ActiveMQDestination dest = this.createDestination("TEST", false);
        ActiveMQDestination dest1 = this.createDestination("TEST1", false);
        NetworkConnector bridgeAB = this.bridgeBrokers("BrokerA", "BrokerB", true);
        bridgeAB.addStaticallyIncludedDestination(dest);
        bridgeAB.setStaticBridge(true);
        this.startAllBrokers();
        this.waitForBridgeFormation();
        MessageConsumer consumer1 = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer consumer2 = this.createConsumer("BrokerB", (Destination)dest1);
        Thread.sleep(1000L);
        this.sendMessages("BrokerA", (Destination)dest, 1);
        this.sendMessages("BrokerA", (Destination)dest1, 1);
        MessageIdList msgs1 = this.getConsumerMessages("BrokerB", consumer1);
        MessageIdList msgs2 = this.getConsumerMessages("BrokerB", consumer2);
        msgs1.waitForMessagesToArrive(1);
        Thread.sleep(1000L);
        StaticNetworkTest.assertEquals((int)1, (int)msgs1.getMessageCount());
        StaticNetworkTest.assertEquals((int)0, (int)msgs2.getMessageCount());
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.createBroker(new URI("broker:(tcp://localhost:61616)/BrokerA?persistent=false&useJmx=false"));
        this.createBroker(new URI("broker:(tcp://localhost:61617)/BrokerB?persistent=false&useJmx=false"));
    }
}

