/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.XARecoveryBrokerTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;

public class KahaDBXARecoveryBrokerTest
extends XARecoveryBrokerTest {
    @Override
    protected void configureBroker(BrokerService broker) throws Exception {
        super.configureBroker(broker);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
    }

    public static Test suite() {
        return KahaDBXARecoveryBrokerTest.suite(KahaDBXARecoveryBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)KahaDBXARecoveryBrokerTest.suite());
    }

    @Override
    protected ActiveMQDestination createDestination() {
        return new ActiveMQQueue("test");
    }

    public void testPreparedTransactionRecoveredPurgeCommitOnRestart() throws Exception {
        int i;
        ActiveMQDestination destination = this.createDestination();
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send((Command)consumerInfo);
        for (i = 0; i < 4; ++i) {
            XATransactionId txid = this.createXATransaction(sessionInfo);
            connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            message.setTransactionId((TransactionId)txid);
            connection.send((Command)message);
            connection.send((Command)this.createPrepareTransaction(connectionInfo, (TransactionId)txid));
        }
        KahaDBXARecoveryBrokerTest.assertNull((Object)this.receiveMessage(connection));
        this.assertNoMessagesLeft(connection);
        connection.request((Command)this.closeConnectionInfo(connectionInfo));
        this.stopBroker();
        if (this.broker.getPersistenceAdapter() instanceof KahaDBPersistenceAdapter) {
            KahaDBPersistenceAdapter adapter = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
            adapter.setPurgeRecoveredXATransactionStrategy("COMMIT");
            LOG.info("Setting purgeRecoveredXATransactions to true on the KahaDBPersistenceAdapter");
        }
        this.broker.start();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send((Command)consumerInfo);
        for (i = 0; i < 4; ++i) {
            KahaDBXARecoveryBrokerTest.assertNotNull((Object)this.receiveMessage(connection));
        }
        this.assertNoMessagesLeft(connection);
        Response response = connection.request((Command)new TransactionInfo(connectionInfo.getConnectionId(), null, 5));
        KahaDBXARecoveryBrokerTest.assertNotNull((Object)response);
        DataArrayResponse dar = (DataArrayResponse)response;
        KahaDBXARecoveryBrokerTest.assertEquals((int)0, (int)dar.getData().length);
    }

    public void testPreparedTransactionRecoveredPurgeRollbackOnRestart() throws Exception {
        ActiveMQDestination destination = this.createDestination();
        StubConnection connection = this.createConnection();
        ConnectionInfo connectionInfo = this.createConnectionInfo();
        SessionInfo sessionInfo = this.createSessionInfo(connectionInfo);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        connection.send((Command)producerInfo);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send((Command)consumerInfo);
        for (int i = 0; i < 4; ++i) {
            XATransactionId txid = this.createXATransaction(sessionInfo);
            connection.send((Command)this.createBeginTransaction(connectionInfo, (TransactionId)txid));
            Message message = this.createMessage(producerInfo, destination);
            message.setPersistent(true);
            message.setTransactionId((TransactionId)txid);
            connection.send((Command)message);
            connection.send((Command)this.createPrepareTransaction(connectionInfo, (TransactionId)txid));
        }
        KahaDBXARecoveryBrokerTest.assertNull((Object)this.receiveMessage(connection));
        this.assertNoMessagesLeft(connection);
        connection.request((Command)this.closeConnectionInfo(connectionInfo));
        this.stopBroker();
        if (this.broker.getPersistenceAdapter() instanceof KahaDBPersistenceAdapter) {
            KahaDBPersistenceAdapter adapter = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
            adapter.setPurgeRecoveredXATransactionStrategy("ROLLBACK");
            LOG.info("Setting purgeRecoveredXATransactions to true on the KahaDBPersistenceAdapter");
        }
        this.broker.start();
        connection = this.createConnection();
        connectionInfo = this.createConnectionInfo();
        sessionInfo = this.createSessionInfo(connectionInfo);
        connection.send((Command)connectionInfo);
        connection.send((Command)sessionInfo);
        consumerInfo = this.createConsumerInfo(sessionInfo, destination);
        connection.send((Command)consumerInfo);
        KahaDBXARecoveryBrokerTest.assertNull((Object)this.receiveMessage(connection));
        this.assertNoMessagesLeft(connection);
        Response response = connection.request((Command)new TransactionInfo(connectionInfo.getConnectionId(), null, 5));
        KahaDBXARecoveryBrokerTest.assertNotNull((Object)response);
        DataArrayResponse dar = (DataArrayResponse)response;
        KahaDBXARecoveryBrokerTest.assertEquals((int)0, (int)dar.getData().length);
    }
}

