/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.TestSupport;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.xbean.XBeanBrokerService;
import org.junit.Test;

public class JMXMasterSlaveSharedStoreTest
extends TestSupport {
    protected XBeanBrokerService master;
    protected XBeanBrokerService slave;
    protected AtomicReference<XBeanBrokerService> slaveAtomicReference = new AtomicReference();
    protected CountDownLatch slaveStarted = new CountDownLatch(1);
    protected PersistenceAdapter persistenceAdapter;
    protected File messageStore;
    protected File schedulerStoreFile;

    protected void setUp() throws Exception {
        this.setMaxTestTime(TimeUnit.MINUTES.toMillis(10L));
        this.setAutoFail(true);
        this.messageStore = new File("target/activemq-data/kahadb/JMXMasterSlaveSharedStoreTest");
        this.schedulerStoreFile = new File("target/activemq-data/scheduler/JMXMasterSlaveSharedStoreTest/");
        if (System.getProperty("basedir") == null) {
            File file = new File(".");
            System.setProperty("basedir", file.getAbsolutePath());
        }
        this.createMaster();
        Thread.sleep(1000L);
        this.createSlave();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.slave != null) {
            this.slave.stop();
        }
        if (this.master != null) {
            this.master.stop();
        }
    }

    protected void createMaster() throws Exception {
        this.master = this.createXBeanBrokerService("master");
        this.master.afterPropertiesSet();
    }

    protected void createSlave() throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    JMXMasterSlaveSharedStoreTest.this.slave = JMXMasterSlaveSharedStoreTest.this.createXBeanBrokerService("slave");
                    JMXMasterSlaveSharedStoreTest.this.slave.afterPropertiesSet();
                    JMXMasterSlaveSharedStoreTest.this.slaveAtomicReference.set(JMXMasterSlaveSharedStoreTest.this.slave);
                    JMXMasterSlaveSharedStoreTest.this.slaveStarted.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        Thread.sleep(100L);
    }

    private XBeanBrokerService createXBeanBrokerService(String name) throws Exception {
        String[] connectors = new String[]{"tcp://localhost:0"};
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(this.messageStore);
        XBeanBrokerService broker = new XBeanBrokerService();
        broker.setUseJmx(true);
        broker.setBrokerName(name);
        broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        broker.setTransportConnectorURIs(connectors);
        broker.setSchedulerSupport(true);
        broker.setSchedulerDirectoryFile(this.schedulerStoreFile);
        broker.getManagementContext().setCreateConnector(false);
        return broker;
    }

    private String getXBeanBrokerServiceMBeanName(String brokerName) {
        return "org.apache.activemq:type=Broker,brokerName=" + brokerName;
    }

    @Test
    public void testJMXMBeanIsRegisteredForSlave() throws Exception {
        JMXMasterSlaveSharedStoreTest.assertFalse((boolean)this.master.isSlave());
        JMXMasterSlaveSharedStoreTest.assertTrue((boolean)this.slave.isSlave());
        ObjectName masterMBeanName = new ObjectName(this.getXBeanBrokerServiceMBeanName("master"));
        ObjectName slaveMBeanName = new ObjectName(this.getXBeanBrokerServiceMBeanName("slave"));
        MBeanServer connection = this.master.getManagementContext().getMBeanServer();
        JMXMasterSlaveSharedStoreTest.assertFalse((boolean)connection.queryMBeans(masterMBeanName, null).isEmpty());
        JMXMasterSlaveSharedStoreTest.assertFalse((boolean)connection.queryMBeans(slaveMBeanName, null).isEmpty());
    }
}

