/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.io.File;
import java.time.Duration;
import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.HeaderMessageInterceptorStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.MessageInterceptorStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.test.TestSupport;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class MessageInterceptorStrategyTest
extends TestSupport {
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    MessageProducer producer;
    QueueBrowser queueBrowser;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        File testDataDir = new File("target/activemq-data/message-interceptor-strategy");
        this.broker.setDataDirectoryFile(testDataDir);
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x4000000L);
        this.broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    @After
    public void tearDown() throws Exception {
        if (this.producer != null) {
            this.producer.close();
        }
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.stop();
    }

    @Test
    public void testForceDeliveryModePersistent() throws Exception {
        this.applyHeaderMessageInterceptor(true, true, false, 0L, Long.MAX_VALUE);
        Queue queue = this.createQueue("mis.forceDeliveryMode.true");
        TextMessage sendMessageP = this.session.createTextMessage("forceDeliveryMode=true");
        this.producer.setDeliveryMode(2);
        this.producer.send((Destination)queue, (Message)sendMessageP);
        TextMessage sendMessageNP = this.session.createTextMessage("forceDeliveryMode=true");
        this.producer.setDeliveryMode(1);
        this.producer.send((Destination)queue, (Message)sendMessageNP);
        this.queueBrowser = this.session.createBrowser(queue);
        Enumeration browseEnumeration = this.queueBrowser.getEnumeration();
        int count = 0;
        while (browseEnumeration.hasMoreElements()) {
            Message message = (Message)browseEnumeration.nextElement();
            MessageInterceptorStrategyTest.assertEquals((int)2, (int)message.getJMSDeliveryMode());
            ++count;
        }
        MessageInterceptorStrategyTest.assertEquals((Object)2, (Object)count);
    }

    @Test
    public void testForceDeliveryModeNonPersistent() throws Exception {
        this.applyHeaderMessageInterceptor(true, false, false, 0L, Long.MAX_VALUE);
        Queue queue = this.createQueue("mis.forceDeliveryMode.false");
        TextMessage sendMessageP = this.session.createTextMessage("forceDeliveryMode=false");
        this.producer.setDeliveryMode(2);
        this.producer.send((Destination)queue, (Message)sendMessageP);
        TextMessage sendMessageNP = this.session.createTextMessage("forceDeliveryMode=false");
        this.producer.setDeliveryMode(1);
        this.producer.send((Destination)queue, (Message)sendMessageNP);
        this.queueBrowser = this.session.createBrowser(queue);
        Enumeration browseEnumeration = this.queueBrowser.getEnumeration();
        int count = 0;
        while (browseEnumeration.hasMoreElements()) {
            Message message = (Message)browseEnumeration.nextElement();
            MessageInterceptorStrategyTest.assertEquals((int)1, (int)message.getJMSDeliveryMode());
            ++count;
        }
        MessageInterceptorStrategyTest.assertEquals((Object)2, (Object)count);
    }

    @Test
    public void testForceExpirationDisabled() throws Exception {
        this.applyHeaderMessageInterceptor(false, false, false, 100000L, Long.MAX_VALUE);
        Queue queue = this.createQueue("mis.forceExpiration.zero");
        TextMessage sendMessageP = this.session.createTextMessage("expiration=zero");
        this.producer.setTimeToLive(0L);
        this.producer.send((Destination)queue, (Message)sendMessageP);
        this.queueBrowser = this.session.createBrowser(queue);
        Enumeration browseEnumeration = this.queueBrowser.getEnumeration();
        int count = 0;
        while (browseEnumeration.hasMoreElements()) {
            Message message = (Message)browseEnumeration.nextElement();
            MessageInterceptorStrategyTest.assertEquals((Object)0L, (Object)message.getJMSExpiration());
            ++count;
        }
        MessageInterceptorStrategyTest.assertEquals((Object)1, (Object)count);
    }

    @Test
    public void testForceExpirationZeroOverride() throws Exception {
        long expiryTime = 100000L;
        this.applyHeaderMessageInterceptor(false, false, true, expiryTime, Long.MAX_VALUE);
        long currentTime = System.currentTimeMillis();
        Queue queue = this.createQueue("mis.forceExpiration.100k");
        TextMessage sendMessageP = this.session.createTextMessage("expiration=zero");
        this.producer.setTimeToLive(100000L);
        this.producer.send((Destination)queue, (Message)sendMessageP);
        this.queueBrowser = this.session.createBrowser(queue);
        Enumeration browseEnumeration = this.queueBrowser.getEnumeration();
        int count = 0;
        while (browseEnumeration.hasMoreElements()) {
            Message message = (Message)browseEnumeration.nextElement();
            MessageInterceptorStrategyTest.assertTrue((Long.valueOf(message.getJMSExpiration()) > currentTime + expiryTime / 2L ? 1 : 0) != 0);
            ++count;
        }
        MessageInterceptorStrategyTest.assertEquals((Object)1, (Object)count);
    }

    @Test
    public void testForceExpirationZeroOverrideDLQ() throws Exception {
        long expiryTime = 1L;
        this.applyHeaderMessageInterceptor(false, false, true, expiryTime, Long.MAX_VALUE);
        Queue queue = this.createQueue("mis.forceExpiration.zero-no-dlq-expiry");
        TextMessage sendMessageP = this.session.createTextMessage("expiration=zero-no-dlq-expiry");
        this.producer.send((Destination)queue, (Message)sendMessageP);
        Thread.sleep(250L);
        this.queueBrowser = this.session.createBrowser(queue);
        Enumeration browseEnumeration = this.queueBrowser.getEnumeration();
        int count = 0;
        while (browseEnumeration.hasMoreElements()) {
            ++count;
        }
        MessageInterceptorStrategyTest.assertEquals((Object)0, (Object)count);
        QueueBrowser dlqQueueBrowser = this.session.createBrowser(this.createQueue("mis.forceExpiration.zero-no-dlq-expiry.dlq"));
        Enumeration dlqBrowseEnumeration = dlqQueueBrowser.getEnumeration();
        int dlqCount = 0;
        while (dlqBrowseEnumeration.hasMoreElements()) {
            Message dlqMessage = (Message)dlqBrowseEnumeration.nextElement();
            MessageInterceptorStrategyTest.assertEquals((String)sendMessageP.getJMSMessageID(), (String)dlqMessage.getJMSMessageID());
            MessageInterceptorStrategyTest.assertEquals((String)("Expiration should be zero" + dlqMessage.getJMSExpiration() + "\n"), (long)dlqMessage.getJMSExpiration(), (long)0L);
            ++dlqCount;
        }
        MessageInterceptorStrategyTest.assertEquals((Object)1, (Object)dlqCount);
    }

    @Test
    public void testForceExpirationCeilingOverride() throws Exception {
        long zeroOverrideExpiryTime = 100000L;
        long expirationCeiling = Duration.ofDays(1L).toMillis();
        this.applyHeaderMessageInterceptor(false, false, true, zeroOverrideExpiryTime, expirationCeiling);
        long currentTime = System.currentTimeMillis();
        long expiryTime = Duration.ofDays(10L).toMillis();
        Queue queue = this.createQueue("mis.forceExpiration.maxValue");
        TextMessage sendMessageP = this.session.createTextMessage("expiration=ceiling");
        this.producer.setTimeToLive(expiryTime);
        this.producer.send((Destination)queue, (Message)sendMessageP);
        this.queueBrowser = this.session.createBrowser(queue);
        Enumeration browseEnumeration = this.queueBrowser.getEnumeration();
        int count = 0;
        while (browseEnumeration.hasMoreElements()) {
            Message message = (Message)browseEnumeration.nextElement();
            MessageInterceptorStrategyTest.assertTrue((Long.valueOf(message.getJMSExpiration()) < currentTime + Duration.ofDays(9L).toMillis() ? 1 : 0) != 0);
            ++count;
        }
        MessageInterceptorStrategyTest.assertEquals((Object)1, (Object)count);
    }

    private PolicyMap applyHeaderMessageInterceptor(boolean forceDeliveryMode, boolean persistent, boolean forceExpiration, long zeroExpirationOverride, long expirationCeiling) {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        HeaderMessageInterceptorStrategy headerMessageInterceptorStrategy = new HeaderMessageInterceptorStrategy();
        headerMessageInterceptorStrategy.setForceDeliveryMode(forceDeliveryMode);
        headerMessageInterceptorStrategy.setPersistent(persistent);
        headerMessageInterceptorStrategy.setForceExpiration(forceExpiration);
        headerMessageInterceptorStrategy.setZeroExpirationOverride(zeroExpirationOverride);
        headerMessageInterceptorStrategy.setExpirationCeiling(expirationCeiling);
        defaultEntry.setMessageInterceptorStrategy((MessageInterceptorStrategy)headerMessageInterceptorStrategy);
        IndividualDeadLetterStrategy individualDeadLetterStrategy = new IndividualDeadLetterStrategy();
        individualDeadLetterStrategy.setQueuePrefix("");
        individualDeadLetterStrategy.setQueueSuffix(".dlq");
        defaultEntry.setDeadLetterStrategy((DeadLetterStrategy)individualDeadLetterStrategy);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        return policyMap;
    }

    private Queue createQueue(String queueName) throws Exception {
        Queue queue = this.session.createQueue(queueName);
        this.producer = this.session.createProducer((Destination)queue);
        return queue;
    }
}

