/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.ConstantPendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.MessageEvictionStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.UniquePropertyMessageEvictionStrategy;
import org.apache.activemq.command.ActiveMQDestination;

public class UniquePropertyMessageEvictionStrategyTest
extends EmbeddedBrokerTestSupport {
    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setTopic(">");
        entry.setAdvisoryForDiscardingMessages(true);
        entry.setTopicPrefetch(1);
        ConstantPendingMessageLimitStrategy pendingMessageLimitStrategy = new ConstantPendingMessageLimitStrategy();
        pendingMessageLimitStrategy.setLimit(10);
        entry.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)pendingMessageLimitStrategy);
        UniquePropertyMessageEvictionStrategy messageEvictionStrategy = new UniquePropertyMessageEvictionStrategy();
        messageEvictionStrategy.setPropertyName("sequenceI");
        entry.setMessageEvictionStrategy((MessageEvictionStrategy)messageEvictionStrategy);
        entry.setDeadLetterStrategy(null);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        broker.setDestinationPolicy(policyMap);
        return broker;
    }

    public void testEviction() throws Exception {
        int i;
        Connection conn = this.connectionFactory.createConnection();
        conn.start();
        Session session = conn.createSession(false, 1);
        Topic destination = session.createTopic("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                TextMessage msg = session.createTextMessage("message " + i + j);
                msg.setIntProperty("sequenceI", i);
                msg.setIntProperty("sequenceJ", j);
                producer.send((Message)msg);
                Thread.sleep(100L);
            }
        }
        for (i = 0; i < 11; ++i) {
            Message msg = consumer.receive(1000L);
            UniquePropertyMessageEvictionStrategyTest.assertNotNull((Object)msg);
            int seqI = msg.getIntProperty("sequenceI");
            int seqJ = msg.getIntProperty("sequenceJ");
            if (i == 0) {
                UniquePropertyMessageEvictionStrategyTest.assertEquals((int)0, (int)seqI);
                UniquePropertyMessageEvictionStrategyTest.assertEquals((int)0, (int)seqJ);
                continue;
            }
            UniquePropertyMessageEvictionStrategyTest.assertEquals((int)9, (int)seqJ);
            UniquePropertyMessageEvictionStrategyTest.assertEquals((int)(i - 1), (int)seqI);
        }
        Message msg = consumer.receive(1000L);
        UniquePropertyMessageEvictionStrategyTest.assertNull((Object)msg);
        UniquePropertyMessageEvictionStrategyTest.assertEquals((String)"usage goes to 0", (long)0L, (long)TestSupport.getDestination(this.broker, ActiveMQDestination.transform((Destination)destination)).getMemoryUsage().getUsage());
    }
}

