/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.cursors.CursorSupport;

public class CursorDurableTest
extends CursorSupport {
    @Override
    protected Destination getDestination(Session session) throws JMSException {
        String topicName = ((Object)((Object)this)).getClass().getName();
        return session.createTopic(topicName);
    }

    @Override
    protected Connection getConsumerConnection(ConnectionFactory fac) throws JMSException {
        Connection connection = fac.createConnection();
        connection.setClientID("testConsumer");
        connection.start();
        return connection;
    }

    @Override
    protected MessageConsumer getConsumer(Connection connection) throws Exception {
        Session consumerSession = connection.createSession(false, 1);
        Topic topic = (Topic)this.getDestination(consumerSession);
        TopicSubscriber consumer = consumerSession.createDurableSubscriber(topic, "testConsumer");
        return consumer;
    }

    @Override
    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setDeleteAllMessagesOnStartup(true);
        answer.addConnector(this.bindAddress);
        answer.setDeleteAllMessagesOnStartup(true);
    }
}

