/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.JobSchedulerViewMBean;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class JobSchedulerTestSupport {
    @Rule
    public TestName name = new TestName();
    protected String connectionUri;
    protected BrokerService broker;
    protected JobScheduler jobScheduler;
    protected Queue destination;

    @Before
    public void setUp() throws Exception {
        this.connectionUri = "vm://localhost";
        this.destination = new ActiveMQQueue(this.name.getMethodName());
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.jobScheduler = this.broker.getJobSchedulerStore().getJobScheduler("JMS");
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    protected Connection createConnection() throws Exception {
        return this.createConnectionFactory().createConnection();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    protected BrokerService createBroker() throws Exception {
        return this.createBroker(true);
    }

    protected boolean isUseJmx() {
        return false;
    }

    protected boolean isPersistent() {
        return true;
    }

    protected JobSchedulerViewMBean getJobSchedulerMBean() throws Exception {
        ObjectName objectName = this.broker.getAdminView().getJMSJobScheduler();
        JobSchedulerViewMBean scheduler = null;
        if (objectName != null) {
            scheduler = (JobSchedulerViewMBean)this.broker.getManagementContext().newProxyInstance(objectName, JobSchedulerViewMBean.class, true);
        }
        return scheduler;
    }

    protected BrokerService createBroker(boolean delete) throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        if (delete) {
            IOHelper.mkdirs((File)schedulerDirectory);
            IOHelper.deleteChildren((File)schedulerDirectory);
        }
        BrokerService answer = new BrokerService();
        answer.setPersistent(this.isPersistent());
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setDataDirectory("target");
        answer.setSchedulerDirectoryFile(schedulerDirectory);
        answer.setSchedulerSupport(true);
        answer.setUseJmx(this.isUseJmx());
        return answer;
    }

    protected void restartBroker(RestartType restartType) throws Exception {
        File dir;
        this.tearDown();
        if (restartType == RestartType.FULL_RECOVERY && (dir = this.broker.getSchedulerDirectoryFile()) != null) {
            IOHelper.deleteFile((File)new File(dir, "scheduleDB.data"));
            IOHelper.deleteFile((File)new File(dir, "scheduleDB.redo"));
        }
        this.broker = this.createBroker(false);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    static enum RestartType {
        NORMAL,
        FULL_RECOVERY;

    }
}

