/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.scheduler.JobSchedulerTestSupport;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JobSchedulerWithAdvisoryMessageTest
extends JobSchedulerTestSupport {
    final AtomicLong uniqueQueueId = new AtomicLong(System.currentTimeMillis());
    private Connection connection;
    private Session session;
    private List<String> queuesCreated;

    @Before
    public void setupQueueCreationObserver() throws Exception {
        Assert.assertTrue((boolean)this.broker.isAdvisorySupport());
        this.connection = this.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.queuesCreated = new ArrayList<String>();
        MessageConsumer consumer = this.session.createConsumer((Destination)AdvisorySupport.QUEUE_ADVISORY_TOPIC);
        consumer.setMessageListener(msg -> {
            ActiveMQMessage activeMessage = (ActiveMQMessage)msg;
            DataStructure command = activeMessage.getDataStructure();
            if (command instanceof DestinationInfo) {
                DestinationInfo destinationInfo = (DestinationInfo)command;
                String physicalName = destinationInfo.getDestination().getPhysicalName();
                if (destinationInfo.isAddOperation()) {
                    this.queuesCreated.add(physicalName);
                }
            }
        });
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.session.close();
        this.connection.close();
        super.tearDown();
    }

    @Test
    public void sendDelayedMessage_usingNormalProducer() throws Exception {
        String queueName = this.getNewQueueName();
        Queue destination = this.session.createQueue(queueName);
        JobSchedulerWithAdvisoryMessageTest.delay(200L);
        Assert.assertFalse((boolean)this.queuesCreated.contains(queueName));
        MessageProducer producer = this.session.createProducer((Destination)destination);
        JobSchedulerWithAdvisoryMessageTest.delay(200L);
        Assert.assertTrue((boolean)this.queuesCreated.contains(queueName));
        producer.send(this.createDelayedMessage());
        Assert.assertTrue((boolean)this.queuesCreated.contains(queueName));
    }

    @Test
    public void sendDelayedMessage_usingAnonymousProducer() throws Exception {
        String queueName = this.getNewQueueName();
        Queue destination = this.session.createQueue(queueName);
        JobSchedulerWithAdvisoryMessageTest.delay(200L);
        Assert.assertFalse((boolean)this.queuesCreated.contains(queueName));
        MessageProducer anonymousProducer = this.session.createProducer(null);
        JobSchedulerWithAdvisoryMessageTest.delay(200L);
        Assert.assertFalse((boolean)this.queuesCreated.contains(queueName));
        anonymousProducer.send((Destination)destination, this.createDelayedMessage());
        JobSchedulerWithAdvisoryMessageTest.delay(500L);
        Assert.assertTrue((boolean)this.queuesCreated.contains(queueName));
    }

    private Message createDelayedMessage() throws JMSException {
        TextMessage message = this.session.createTextMessage("delayed message");
        message.setLongProperty("AMQ_SCHEDULED_DELAY", 5L);
        return message;
    }

    private String getNewQueueName() {
        return "queue-" + this.uniqueQueueId.getAndIncrement();
    }

    public static void delay(long delayMs) {
        try {
            Thread.sleep(delayMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

