/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.io.IOException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.scheduler.JobSchedulerStore;
import org.apache.activemq.broker.scheduler.KahaDBSchedulerIndexRebuildTest;
import org.apache.activemq.broker.scheduler.SchedulerDBVersionTest;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KahaDBSchedulerMissingJournalLogsTest {
    static final Logger LOG = LoggerFactory.getLogger(KahaDBSchedulerIndexRebuildTest.class);
    private BrokerService broker = null;
    private JobSchedulerStoreImpl schedulerStore = null;
    private final int NUM_LOGS = 6;
    static String basedir;
    private final File schedulerStoreDir = new File(basedir, "activemq-data/store/scheduler");
    private final File storeDir = new File(basedir, "activemq-data/store/");

    @Before
    public void setUp() throws Exception {
        IOHelper.deleteFile((File)this.schedulerStoreDir);
        LOG.info("Test Dir = {}", (Object)this.schedulerStoreDir);
        this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.schedulerStore = (JobSchedulerStoreImpl)this.broker.getJobSchedulerStore();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=120000L)
    public void testMissingLogsCausesBrokerToFail() throws Exception {
        this.fillUpSomeLogFiles();
        int jobCount = this.schedulerStore.getJobScheduler("JMS").getAllJobs().size();
        LOG.info("There are {} jobs in the store.", (Object)jobCount);
        ArrayList<File> toDelete = new ArrayList<File>();
        Map files = this.schedulerStore.getJournal().getFileMap();
        for (int i = files.size(); i > files.size() / 2; --i) {
            toDelete.add(((DataFile)files.get(i)).getFile());
        }
        this.broker.stop();
        this.broker.waitUntilStopped();
        for (File file : toDelete) {
            LOG.info("File to delete: {}", (Object)file);
            IOHelper.delete((File)file);
        }
        try {
            this.createBroker();
            this.broker.start();
            Assert.fail((String)"Should not start when logs are missing.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(timeout=120000L)
    public void testRecoverWhenSomeLogsAreMissing() throws Exception {
        this.fillUpSomeLogFiles();
        int jobCount = this.schedulerStore.getJobScheduler("JMS").getAllJobs().size();
        LOG.info("There are {} jobs in the store.", (Object)jobCount);
        ArrayList<File> toDelete = new ArrayList<File>();
        Map files = this.schedulerStore.getJournal().getFileMap();
        for (int i = files.size() - 1; i > files.size() / 2; --i) {
            toDelete.add(((DataFile)files.get(i)).getFile());
        }
        this.broker.stop();
        this.broker.waitUntilStopped();
        for (File file : toDelete) {
            LOG.info("File to delete: {}", (Object)file);
            IOHelper.delete((File)file);
        }
        this.schedulerStore = this.createScheduler();
        this.schedulerStore.setIgnoreMissingJournalfiles(true);
        this.createBroker(this.schedulerStore);
        this.broker.start();
        this.broker.waitUntilStarted();
        int postRecoverJobCount = this.schedulerStore.getJobScheduler("JMS").getAllJobs().size();
        Assert.assertTrue((postRecoverJobCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((postRecoverJobCount < jobCount ? 1 : 0) != 0);
    }

    private void fillUpSomeLogFiles() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("test.queue");
        MessageProducer producer = session.createProducer((Destination)queue);
        connection.start();
        do {
            this.scheduleRepeating(session, producer);
        } while (this.schedulerStore.getJournal().getFileMap().size() != 6);
        connection.close();
    }

    private void scheduleRepeating(Session session, MessageProducer producer) throws Exception {
        TextMessage message = session.createTextMessage("test msg");
        long time = 360000L;
        message.setLongProperty("AMQ_SCHEDULED_DELAY", time);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", 500L);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", 0);
        producer.send((Message)message);
    }

    protected JobSchedulerStoreImpl createScheduler() {
        JobSchedulerStoreImpl scheduler = new JobSchedulerStoreImpl();
        scheduler.setDirectory(this.schedulerStoreDir);
        scheduler.setJournalMaxFileLength(10240);
        return scheduler;
    }

    protected void createBroker() throws Exception {
        this.createBroker(this.createScheduler());
    }

    protected void createBroker(JobSchedulerStoreImpl scheduler) throws Exception {
        this.broker = new BrokerService();
        this.broker.setJobSchedulerStore((JobSchedulerStore)scheduler);
        this.broker.setPersistent(true);
        this.broker.setDataDirectory(this.storeDir.getAbsolutePath());
        this.broker.setSchedulerSupport(true);
        this.broker.setUseJmx(false);
    }

    static {
        try {
            ProtectionDomain protectionDomain = SchedulerDBVersionTest.class.getProtectionDomain();
            basedir = new File(new File(protectionDomain.getCodeSource().getLocation().getPath()), "../.").getCanonicalPath();
        }
        catch (IOException e) {
            basedir = ".";
        }
    }
}

