/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.util.TraceBrokerPathPlugin;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TraceBrokerPathPluginTest
extends TestCase {
    BrokerService brokerA;
    BrokerService brokerB;
    TransportConnector tcpConnectorA;
    TransportConnector tcpConnectorB;
    MessageProducer producer;
    MessageConsumer consumer;
    Connection connectionA;
    Connection connectionB;
    Session sessionA;
    Session sessionB;
    String queue = "TEST.FOO";
    String traceProperty = "BROKER_PATH";

    @Before
    public void setUp() throws Exception {
        TraceBrokerPathPlugin tbppA = new TraceBrokerPathPlugin();
        tbppA.setStampProperty(this.traceProperty);
        TraceBrokerPathPlugin tbppB = new TraceBrokerPathPlugin();
        tbppB.setStampProperty(this.traceProperty);
        this.brokerA = new BrokerService();
        this.brokerA.setBrokerName("brokerA");
        this.brokerA.setPersistent(false);
        this.brokerA.setUseJmx(true);
        this.brokerA.setPlugins(new BrokerPlugin[]{tbppA});
        this.tcpConnectorA = this.brokerA.addConnector("tcp://localhost:0");
        this.brokerB = new BrokerService();
        this.brokerB.setBrokerName("brokerB");
        this.brokerB.setPersistent(false);
        this.brokerB.setUseJmx(true);
        this.brokerB.setPlugins(new BrokerPlugin[]{tbppB});
        this.tcpConnectorB = this.brokerB.addConnector("tcp://localhost:0");
        this.brokerA.addNetworkConnector("static:(" + this.tcpConnectorB.getConnectUri().toString() + ")");
        this.brokerB.start();
        this.brokerB.waitUntilStarted();
        this.brokerA.start();
        this.brokerA.waitUntilStarted();
        this.connectionA = new ActiveMQConnectionFactory(this.tcpConnectorA.getConnectUri()).createConnection();
        this.connectionA.start();
        this.sessionA = this.connectionA.createSession(false, 1);
        this.producer = this.sessionA.createProducer((Destination)this.sessionA.createQueue(this.queue));
        this.producer.setDeliveryMode(1);
        this.connectionB = new ActiveMQConnectionFactory(this.tcpConnectorB.getConnectUri()).createConnection();
        this.connectionB.start();
        this.sessionB = this.connectionB.createSession(false, 1);
        this.consumer = this.sessionB.createConsumer((Destination)this.sessionB.createQueue(this.queue));
    }

    @After
    public void tearDown() throws Exception {
        this.producer.close();
        this.consumer.close();
        this.sessionA.close();
        this.sessionB.close();
        this.connectionA.close();
        this.connectionB.close();
        this.brokerA.stop();
        this.brokerB.stop();
    }

    @Test
    public void testTraceBrokerPathPlugin() throws Exception {
        Message sentMessage = this.sessionA.createMessage();
        this.producer.send(sentMessage);
        Message receivedMessage = this.consumer.receive(1000L);
        TraceBrokerPathPluginTest.assertNotNull((Object)receivedMessage);
        TraceBrokerPathPluginTest.assertEquals((String)sentMessage.getJMSMessageID(), (String)receivedMessage.getJMSMessageID());
        TraceBrokerPathPluginTest.assertEquals((String)"brokerA,brokerB", (String)receivedMessage.getStringProperty(this.traceProperty));
    }
}

