/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3934Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ3934Test.class);
    private static BrokerService brokerService;
    private static String TEST_QUEUE;
    private static ActiveMQQueue queue;
    private static String BROKER_ADDRESS;
    private ActiveMQConnectionFactory connectionFactory;
    private String connectionUri;
    private String messageID;

    @Before
    public void setUp() throws Exception {
        brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        this.connectionUri = brokerService.addConnector(BROKER_ADDRESS).getPublishableConnectString();
        brokerService.start();
        brokerService.waitUntilStarted();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage() throws Exception {
        try (Connection conn = this.connectionFactory.createConnection();){
            conn.start();
            Session session = conn.createSession(false, 1);
            Queue queue = session.createQueue(TEST_QUEUE);
            Message toSend = session.createMessage();
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Destination)queue, toSend);
        }
    }

    @After
    public void tearDown() throws Exception {
        brokerService.stop();
        brokerService.waitUntilStopped();
    }

    @Test
    public void getMessage() throws Exception {
        QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        CompositeData[] messages = queueView.browse();
        this.messageID = (String)messages[0].get("JMSMessageID");
        Assert.assertNotNull((Object)this.messageID);
        Assert.assertNotNull((Object)queueView.getMessage(this.messageID));
        LOG.debug("Attempting to remove message ID: " + this.messageID);
        queueView.removeMessage(this.messageID);
        Assert.assertNull((Object)queueView.getMessage(this.messageID));
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, NullPointerException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + queue.getQueueName());
        QueueViewMBean proxy = (QueueViewMBean)brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    static {
        TEST_QUEUE = "testQueue";
        queue = new ActiveMQQueue(TEST_QUEUE);
        BROKER_ADDRESS = "tcp://localhost:0";
    }
}

