/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.IndividualDeadLetterStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ4513Test {
    private BrokerService brokerService;
    private String connectionUri;

    @Before
    public void setup() throws Exception {
        this.brokerService = new BrokerService();
        this.connectionUri = this.brokerService.addConnector("tcp://localhost:0").getPublishableConnectString();
        IndividualDeadLetterStrategy strategy = new IndividualDeadLetterStrategy();
        strategy.setUseQueueForQueueMessages(true);
        strategy.setQueuePrefix("DLQ.");
        strategy.setProcessNonPersistent(false);
        strategy.setProcessExpired(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setTimeBeforeDispatchStarts(3000);
        policy.setDeadLetterStrategy((DeadLetterStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.brokerService.setDestinationPolicy(pMap);
        this.brokerService.setPersistent(false);
        this.brokerService.start();
    }

    @After
    public void stop() throws Exception {
        this.brokerService.stop();
    }

    @Test(timeout=360000L)
    public void test() throws Exception {
        final ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.connectionUri);
        ExecutorService service = Executors.newFixedThreadPool(25);
        final Random ripple = new Random(System.currentTimeMillis());
        for (int i = 0; i < 1000; ++i) {
            service.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
                        Session session = connection.createSession(false, 1);
                        TemporaryQueue destination = session.createTemporaryQueue();
                        session.createProducer((Destination)destination);
                        connection.close();
                        TimeUnit.MILLISECONDS.sleep(ripple.nextInt(20));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            service.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
                        Session session = connection.createSession(false, 1);
                        TemporaryQueue destination = session.createTemporaryQueue();
                        MessageProducer producer = session.createProducer((Destination)destination);
                        producer.setDeliveryMode(1);
                        producer.setTimeToLive(400L);
                        producer.send((Message)session.createTextMessage());
                        producer.send((Message)session.createTextMessage());
                        TimeUnit.MILLISECONDS.sleep(500L);
                        connection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            service.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveMQConnection connection = (ActiveMQConnection)cf.createConnection();
                        Session session = connection.createSession(false, 1);
                        TemporaryQueue destination = session.createTemporaryQueue();
                        session.createProducer((Destination)destination);
                        connection.close();
                        TimeUnit.MILLISECONDS.sleep(ripple.nextInt(20));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        service.shutdown();
        Assert.assertTrue((boolean)service.awaitTermination(5L, TimeUnit.MINUTES));
    }
}

