/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6522Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ6522Test.class);
    private BrokerService broker;
    private ActiveMQConnectionFactory connectionFactory;
    private final Destination destination = new ActiveMQQueue("large_message_queue");
    private String connectionUri;

    @Before
    public void setUp() throws Exception {
        this.initBroker(true);
    }

    public void initBroker(Boolean deleteAllMessages) throws Exception {
        this.broker = this.createBroker();
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessages.booleanValue());
        this.connectionUri = this.broker.addConnector("tcp://localhost:0").getPublishableConnectString();
        this.broker.start();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        PolicyEntry policy = new PolicyEntry();
        policy.setUseCache(false);
        broker.setDestinationPolicy(new PolicyMap());
        broker.getDestinationPolicy().setDefaultEntry(policy);
        KahaDBPersistenceAdapter kahadb = new KahaDBPersistenceAdapter();
        kahadb.setCheckForCorruptJournalFiles(true);
        kahadb.setPreallocationScope(Journal.PreallocationScope.NONE.name());
        broker.setPersistenceAdapter((PersistenceAdapter)kahadb);
        broker.setUseJmx(false);
        return broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyMessageExceedsJournalRestartRecoveryCheck() throws Exception {
        Session session;
        connection.start();
        try (Connection connection = this.connectionFactory.createConnection();){
            session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(this.destination);
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(new byte[0x2100000]);
            producer.send((Message)message);
        }
        this.tearDown();
        this.initBroker(false);
        connection = this.connectionFactory.createConnection();
        connection.start();
        try {
            session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer(this.destination);
            Assert.assertNotNull((String)"Got message after restart", (Object)consumer.receive(20000L));
        }
        finally {
            connection.close();
        }
    }
}

